#include "btbee.h"
 
btbee::btbee(PinName respin, PinName tx, PinName rx) : 
  Serial(tx,  rx) , reset_out(respin) 
{
  reset_out.write(1);
  baud(DEFAULT_BAUD); 
}
 
btbee::btbee( ) : 
  Serial(p28,p27),  reset_out(p26)
{
  reset_out.write(1); 
  baud(DEFAULT_BAUD); 
}
 
void btbee::reset(void){
reset_out.write(0);
wait(0.01);
reset_out.write(1);
}
 
void btbee::at_baud(void){
baud(AT_BAUD);
}
 
void btbee::factory_baud(void){
baud(FACTORY_BAUD);
}
 
void btbee::default_baud(void){
baud(DEFAULT_BAUD);
}
 
/* Read from the serial as long as it is readable. 
*  Params: pointer to char array for the return, 
*          int containing the length of the char array
*          pointer to int for return of chars read 
*  Return: 1 if ok, 0 if array full but more there to read
*/
int btbee::read_all(char * arr, const int len, int * chars_read){
int pos=0;
while (readable()){
    if (pos==len){return 0;}
    arr[pos]=getc(); 
    pos++;
    *chars_read = pos;
}
return 1;
}
 
/* Read from the serial as long as no LF (\n) char has been read.
*  WARNING: This will block your program if no LF is received. 
*  Params: pointer to char array for the return, 
*          int containing the length of the char array
*          pointer to int for return of chars read 
*  Return: 1 if ok, 0 if array full but more there to read
*/
int btbee::read_line(char * arr, const int len, int * chars_read){
int pos=0;
do 
{
    while(!readable()){} //wait until readable
    if (pos==len){return 0;} 
    arr[pos]=getc(); 
    pos++;
    *chars_read = pos;
}
while (!(arr[pos-1]=='\n'));
return 1;
}