#include "./mbed.h"
#include "commands.h"
#include "ringBuffer.h"

static COMMAND_TRRIGER* _ringBuffer[10];
static int _putIndex = 0;
static int _getIndex = 0;
static int _count = 0;

#define COUNT sizeof(_ringBuffer) / sizeof(COMMAND_TRRIGER*)

bool ringbufferPut(COMMAND_TRRIGER* command) {
    bool full = false;
    if (_count <= 0) {
        _ringBuffer[_putIndex] = command;
        _putIndex = (_putIndex < COUNT) ? _putIndex + 1 : 0;
        _count++;
        full = false;
    } else {
        if (_count < COUNT) {
            _ringBuffer[_putIndex] = command;
            _putIndex = (_putIndex < COUNT) ? _putIndex + 1 : 0;
            _count++;
            full = false;
        } else {
            full = true;
        }
    }
    return full;
}

COMMAND_TRRIGER* ringbufferGet(void) {
    COMMAND_TRRIGER* command = NULL;

    if (_count > 0) {
        command = _ringBuffer[_getIndex];
        _getIndex = (_getIndex < COUNT) ? _getIndex + 1 : 0;
        _count--;
    } else {
        command = NULL;
    }
    return command;
}
