#include "./mbed.h"
#include "C12832.h"

#include "commands.h"
#include "ringBuffer.h"

extern COMMAND_TRRIGER   commandList[];
extern COMMAND_TRRIGER   triggerNull;

BusIn joyStick(p15,p12,p13,p16,p14);
C12832 lcd(p5, p7, p6, p8, p11);

int main()
{
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("mbed Switches application");
    
    // デバイスの初期化
    for(int index = 0; commandList[index].trigger != nothing; index++) {
        commandList[index].command->initialize();
    }
    
    COMMAND_TRRIGER *current = &triggerNull;
    COMMAND_TRRIGER *previous = NULL;
    while(true) {
        
        // 中断だったら
        COMMAND_TRRIGER *request = NULL;
        if (joyStick == center) {
            
            // コマンドの終了
            current->command->finalize();
            current = &triggerNull;
            
            // リングバッファのクリア
            while(ringbufferGet() != NULL);
        } else {
            
            // 要求の検索
            for(int index = 0; commandList[index].trigger != nothing; index++) {
                if (joyStick == commandList[index].trigger) {
                    request = &commandList[index];
                }
            }
            
            // 要求があったら
            if (request != NULL) {
                
                // 前回と異なる要求の場合
                if (previous != request) {
                    
                    // コマンドの蓄積
                    bool full = ringbufferPut(request);
                    if (full) {
                        printf("full\n");
                    }
                    
                    // 前回の設定
                    previous = request;
                }    
            } else {
                previous = NULL;
            }
        }

        // 何も処理していない場合に
        if (current->trigger == nothing) {

            // 要求があったら
            COMMAND_TRRIGER* get = ringbufferGet();
            if (get != NULL) {
                
                // コマンドを開始
                current = get;
                lcd.locate(0,15);
                lcd.printf("        ");
                lcd.locate(0,15);
                lcd.printf(current->command->name);
                current->command->processInitialize();
            }
        } else {
            
            // コマンドの実行
            current->command->processRunning();
            
            // コマンドが終わったら
            if (! current->command->processIsContinue()){

                // コマンドの終了
                current->command->finalize();
                current = &triggerNull;
            }
        }
    }
}