typedef struct command{
    char *name;
    void (*initialize)(void);
    void (*finalize)(void);
    void (*processInitialize)(void);
    bool (*processIsContinue)(void);
    void (*processRunning)(void);
} COMMAND_DEFINE;

typedef enum {
    nothing = 0b00000,
    up      = 0b00001,   // p15
    down    = 0b00010,   // p12
    left    = 0b00100,   // p13
    right   = 0b01000,   // p16
    center  = 0b10000,   // p14
} TRIGGER;

typedef struct commandTrigger{
    TRIGGER trigger;
    COMMAND_DEFINE *command;
} COMMAND_TRRIGER;
