#include "./mbed.h"
#include "commands.h"

PwmOut spkr(p26);

static void _Initialize(void) {
    spkr = 0.0;
//    spkr.period_ms(1);
}

static void _Finalize(void) {
    _Initialize();
}

static float _SoundRange = 2000.0;

static void _ProcessInitialize(void) {
    _SoundRange = 2000.0;
}

static bool _ProcessIsContinue(void) {
    return _SoundRange < 10000.0;
}

static void _ProcessRunning(void) {
    spkr.period(1.0 / _SoundRange);
    spkr = 0.5;
    wait(0.1);
    
    _SoundRange += 100;
}

COMMAND_DEFINE Command_sound = {(char*)"sound", _Initialize, _Finalize,
    _ProcessInitialize, _ProcessIsContinue, _ProcessRunning
};