#include "./mbed.h"
#include "commands.h"

PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

static void _Finalize(void) {
    r = 1.0;
    g = 1.0;
    b = 1.0; 
}

static void _Initialize(void) {
    r.period_ms(1);
    _Finalize();
}

static float _ColorRange = 0.0;
static void _ProcessInitialize(void) {
    _ColorRange = 0.0;
}

static bool _ProcessIsContinue(void) {
    return _ColorRange < 1.0;
}

static void _ProcessRunning(void) {
    float p = 3 * _ColorRange;
    r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
    g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
    b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
    wait (0.01);
    
    _ColorRange += 0.001;
}

COMMAND_DEFINE Command_color = {(char*)"color", _Initialize, _Finalize,
    _ProcessInitialize, _ProcessIsContinue, _ProcessRunning
};
