#include "./mbed.h"
#include "commands.h"

DigitalOut liner1(LED1);
DigitalOut liner2(LED2);
DigitalOut liner3(LED3);
DigitalOut liner4(LED4);

static DigitalOut* _ledList[] = {
    &liner1,
    &liner2,
    &liner3,
    &liner4,
    NULL,
};

static int _ledIndex = 0;

static void _Initialize(void) {
    for(int index = 0; _ledList[index] != NULL; index++) {
        *_ledList[index] = 0;
    }
}

static void _Finalize(void) {
    _Initialize();
}

static void _ProcessInitialize(void) {
    _ledIndex = 0;
}

static bool _ProcessIsContinue(void) {
    return _ledList[_ledIndex] != NULL;
}

static void _ProcessRunning(void) {
    *_ledList[_ledIndex] = 1;
    wait(0.1);
    *_ledList[_ledIndex] = 0;
    _ledIndex++;
}

COMMAND_DEFINE Command_liner = {(char*)"liner", _Initialize, _Finalize,
    _ProcessInitialize, _ProcessIsContinue, _ProcessRunning
};
