/**********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/
#include "mbed.h"
#include "bmi160.h"

#include "max32630fthr.h"
#include "USBSerial.h"
#include "stdlib.h"
#include "math.h"
#include "Orientation.h"

//MAX32630HSP icarus(MAX32630HSP::VIO_3V3);
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

Serial daplink(P2_1, P2_0);

DigitalOut rLED(P2_4, LED_ON);
DigitalOut gLED(P2_5, LED_ON);
DigitalOut bLED(P2_6, LED_ON);

DigitalOut M_1(P3_5);
DigitalOut M_2(P3_4);

Orientation orient1;

int main()
{
    gLED = 1;
    bLED = 0;
    wait(1);
    
    
    daplink.printf("Start...");
    orient1.init();
    
    wait(1);
    gLED = 0;
    bLED = 0;

    uint32_t failures = 0;

     
    while(1)
    {
        orient1.updatePitch();
        daplink.printf("Forward: %s%4.3f\r\n", "\033[K", orient1.getPitch());
    }
}     
             
