#include "mbed.h"
#define bufferLength 500
#define muestras 100
#include "math.h"
#include "TextLCD.h"
 


TextLCD lcd(D8, D9, D2, D3, D4, D5, TextLCD::LCD16x2); // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx
struct eResultados {
    float Vrms;
    float Vmax;
    float Vmin;
};
struct estructuraMedidas 
{ 
   float vrms; 
   float irms;  
   float potenciaActiva; 
   float potenciaReactiva;  
   float potenciaAparente;  
   float energiaConsumida;
   float factorDePotencia;
};

estructuraMedidas medidas;

//struct Vectores{
  //  float  vTensionA[muestras];
  //float  vTensionB[muestras];
  //  float  vIntensidadA[muestras];
  //  float  vIntensidadB[muestras];
//}
//vectores;
AnalogIn    adc_in(A0);
AnalogIn    int_in(A1);
AnalogIn    cont_in(A3);
//AnalogOut   dac_out(A2);
//AnalogOut   int_out(A3);
InterruptIn boton(USER_BUTTON);

Ticker tMuestrea;
Ticker tVisualiza;
void visualiza();
void procesado(int length,  int16_t *entrada, int16_t *entrada2);
 void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);
void calcularRMS(int16_t *buffer, int longitud,eResultados *resul);
int flag=0;
int contador=0;
int bufferActivo=0;

struct buffers {
    int16_t vA[muestras];
    int16_t vB[muestras];
    int16_t iA[muestras];
    int16_t iB[muestras];
};


void muestrea();

buffers bufferEntrada;
buffers bufferSalida;

eResultados resultados;

int main()
{

    tMuestrea.attach_us(&muestrea, 100);
    tVisualiza.attach(&visualiza, 5);
    
    while(1) {
        if (flag) {
            flag=0;
            if(bufferActivo==1) {
                procesado(muestras,(int16_t *)&bufferEntrada.vA,(int16_t *)&bufferEntrada.iA);
            } else {
                procesado(muestras,(int16_t *)&bufferEntrada.vB,(int16_t *)&bufferEntrada.iB);
            }
            

        }
    

        wait_us(1);
    }
    
}

void muestrea()
{
    uint16_t dato=adc_in.read_u16();
        uint16_t dato2=int_in.read_u16();
        uint16_t cont=cont_in.read_u16();
        
    if (bufferActivo==0) {

        bufferEntrada.vA[contador]=dato-cont;

        bufferEntrada.iA[contador]=dato2-cont;

    }

    else {

        bufferEntrada.vB[contador]=dato-cont;

        bufferEntrada.iB[contador]=dato2-cont;

    }

    contador++;
    if(contador==muestras) {
        bufferActivo=!bufferActivo;
        contador=0;
        flag=1;
    }

}
void procesado(int length, int16_t *entrada, int16_t *entrada2)
{
  //  for (int i=0; i<length; i++) {
    //    salida[i]=entrada[i];
    //}

//    calcularRMS(entrada,length,&resultados);
      calcularDatos(entrada, entrada2,  100, &medidas);


}
void calcularRMS(int16_t *buffer, int longitud,eResultados *resul)
{
    float cons=0.00005035400390625;
    float cons1=1.007080078125e-4;
    float cons2=cons*cons;

    float res;
    float Vmax=0;
    float Vmin=65535;

    uint64_t suma=0;



    for (int i=0; i<longitud; i++) {

        suma+=buffer[i]*buffer[i];
        if (Vmax<buffer[i]) {
            Vmax=buffer[i];
        }
        if (Vmin>buffer[i]) {
            Vmin=buffer[i];
        }
    }


    res=cons1*sqrt(((float)suma)/longitud);
    resul->Vrms=res;
    resul->Vmax=Vmax*cons;
    resul->Vmin=Vmin*cons;
}

void visualiza(){
    
    printf ("El valor RMS es %f\n",medidas.vrms);
    printf ("El valor irms es %f\n",medidas.irms);
    printf ("El valor energia consumida es %f\n",medidas.energiaConsumida);
    printf ("El valor factor de potencia es %f\n",medidas.factorDePotencia);
    printf ("El valor potencia Aparente es %f\n",medidas.potenciaAparente);
    printf ("El valor potencia Activa es %f\n",medidas.potenciaActiva);
    printf ("El valor potencia Reactiva es %f\n\n",medidas.potenciaReactiva);
    
       
        
 
    
    }
    void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    float cons=1.007080078125e-4;
    float cons2=cons*cons;

    int64_t sumaV=0;
    int64_t sumaI=0;
    int64_t sumaP=0;
   


    float datoV;
    float datoI;
    float datoP;
    float datoS;
    float datoQ;
 

    for (int i=0; i<longitud; i++) {

        sumaV+=datosV[i]*datosV[i];
        sumaI+=datosI[i]*datosI[i];
        sumaP+=datosV[i]*datosI[i];
    }

    datoV = cons*sqrt(((float)sumaV)/longitud);
    datoI = cons*sqrt(((float)sumaI)/longitud);
    datoP = cons2*((float)sumaP)/longitud;
    datoS=datoV*datoI;
    datoQ = sqrt((datoS*datoS)-(datoP*datoP)); 

        (*medidas).energiaConsumida = datoP/datoI;     
        (*medidas).factorDePotencia = datoP/datoS;
        (*medidas).potenciaAparente = datoS;
        (*medidas).potenciaActiva = datoP;
        (*medidas).potenciaReactiva = datoQ;
        (*medidas).vrms = datoV;
        (*medidas).irms = datoI;
 
}    
