#include "mbed.h"
#include "MPU6050.h"

// declaration des entrées analogiques
AnalogIn analog_value_PA4(PA_4);
AnalogIn analog_value_PA5(PA_5);
AnalogIn analog_value_PA6(PA_6);
AnalogIn analog_value_PC0(PC_0);

AnalogIn analog_value_PF3(PF_3);
AnalogIn analog_value_PF4(PF_4);
AnalogIn analog_value_PF9(PF_9);
AnalogIn analog_value_PF10(PF_10);

// declaration des sorties PWM
PwmOut pwm_PE9(PE_9);
PwmOut pwm_PF7(PF_7);
PwmOut pwm_PF6(PF_6);
PwmOut pwm_PC8(PC_8);
PwmOut pwm_PD12(PD_12);

// declaration des IO

DigitalOut led(LED1);
DigitalOut enable_esc(PG_0);

InterruptIn odoInput(PF_8);

#define ROUE_DISTANCE_TIC_2019 0.06
#define ROUE_DISTANCE_TIC_2018 0.08

float roueDistanceTic = ROUE_DISTANCE_TIC_2019; //A changer en ROUE_DISTANCE_TIC_2018 pour chassis 2018
float vitesseBiniou = 0.0; //En m/s
float compteurDistance = 0.0;

Timer odoTick;// temps.start()/stop()/sec: read()/ms: read_ms()/µs: read_us()

void odoTickHandler()
{
    unsigned odoMicroSec = 0;
    //Incremente compteur de distance
    compteurDistance++;
    //Calcule de la vitesse Biniou avec Odometre en fonction de horodatage du TIC odo precedent
    vitesseBiniou = roueDistanceTic / (odoTick.read_ms()*1000);
    
    odoTick.reset();
    odoTick.start();
    
    printf("ODO TICK!\n");
    printf("vitesseBiniou: %f\n", vitesseBiniou);
    printf("compteurDistance: %u\n", compteurDistance);
}

// declaration d'une interruption sur le front de la pin d'odometre
//InterruptRise my_interruptPin(PF_8);

// interruption
//void pressed()
//{
//    cntr_odometre++ ;
//}

// initialisation du MPU6050

Serial pc(USBTX, USBRX,115200);

MPU6050 mpu;


int16_t ax, ay, az;
float ax_g,ay_g,az_g;

int16_t gx, gy, gz;

int main()
{
    float  meas_adc_PA4;
    float  meas_adc_PA5;
    float  meas_adc_PA6;
    float  meas_adc_PC0;

    float  meas_adc_PF3;
    float  meas_adc_PF4;
    float  meas_adc_PF9;
    float  meas_adc_PF10;

    float  meas_adc_PA4_V;
    float  meas_adc_PA5_V;
    float  meas_adc_PA6_V;
    float  meas_adc_PC0_V;

    float  meas_adc_PF3_V;
    float  meas_adc_PF4_V;
    float  meas_adc_PF9_V;
    float  meas_adc_PF10_V;

// configuration des PWMs

    pwm_PE9.period_ms(10);
    pwm_PF7.period_ms(10);
    pwm_PF6.period_ms(10);
    pwm_PC8.period_ms(10);
    pwm_PD12.period_ms(10);

    pwm_PE9.pulsewidth_us(1000);
    pwm_PF7.pulsewidth_us(1250);
    pwm_PF6.pulsewidth_us(1500);
    pwm_PC8.pulsewidth_us(1750);
    pwm_PD12.pulsewidth_us(2000);

//MPU6050
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }

    // Assign functions to Odometre input
    odoInput.fall(&odoTickHandler);

    while(1) {
        // recuperer la valeur en float entre 0.0 et 1.0
        meas_adc_PA4  =  analog_value_PA4.read();
        meas_adc_PA5  =  analog_value_PA5.read();
        meas_adc_PA6  =  analog_value_PA6.read();
        meas_adc_PC0  =  analog_value_PC0.read();

        meas_adc_PF3  =  analog_value_PF3.read();
        meas_adc_PF4  =  analog_value_PF4.read();
        meas_adc_PF9  =  analog_value_PF9.read();
        meas_adc_PF10 =  analog_value_PF10.read();

        // Multiplier par la tension de reference pour avoir la tension en volt
        meas_adc_PA4_V  =  meas_adc_PA4* 3300 ;
        meas_adc_PA5_V  =  meas_adc_PA5* 3300 ;
        meas_adc_PA6_V  =  meas_adc_PA6* 3300 ;
        meas_adc_PC0_V  =  meas_adc_PC0* 3300 ;

        meas_adc_PF3_V  =  meas_adc_PF3* 3300 ;
        meas_adc_PF4_V  =  meas_adc_PF4* 3300 ;
        meas_adc_PF9_V  =  meas_adc_PF9* 3300 ;
        meas_adc_PF10_V =  meas_adc_PF10* 3300 ;

        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        //correction pour avoir une acceleration coef empirique
        ax_g = (float)ax /1658.0 ;
        ay_g = (float)ay /1658.0 ;
        az_g = (float)az /1658.0 ;

        // affiche les valeurs sur la com usb
        printf("\f");
        printf("meas_adc_PA4_V = %.0f mV\n\r", meas_adc_PA4_V);
        printf("meas_adc_PA5_V = %.0f mV\n\r", meas_adc_PA5_V);
        printf("meas_adc_PA6_V = %.0f mV\n\r", meas_adc_PA6_V);
        printf("meas_adc_PC0_V = %.0f mV\n\r", meas_adc_PC0_V);

        printf("meas_adc_PF3_V = %.0f mV\n\r", meas_adc_PF3_V);
        printf("meas_adc_PF4_V = %.0f mV\n\r", meas_adc_PF4_V);
        printf("meas_adc_PF9_V = %.0f mV\n\r", meas_adc_PF9_V);
        printf("meas_adc_PF10_V = %.0f mV\n\r", meas_adc_PF10_V);


        //writing current accelerometer and gyro position

        printf("acc X =%.2f; acc Y =%.2f; acc Z=%.2f;\n\r",ax_g,ay_g,az_g);

        //pc.printf("acc X =%d; acc Y =%d; acc Z=%d; Gyr X =%d; Gyr Y =%d; Gyr Z =%d\n",ax,ay,az,gx,gy,gz);

        led = !led;
        enable_esc = !enable_esc ;
        wait(0.2); // delais
    }
}
