#ifndef UTILS_H
#define UTILS_H

#include "mbed.h"
#include "chassis_mode.h"
#include "log.h"

/*
Structs
*/

typedef struct s_section {
   double targetSpeed_mps;
   double consigne_position;
   double lng_section_m;
   double coef_pos;
   double coef_bord;
   double plagePulseFreinage;
   s_section* nextSection;
}s_Section;

/*
Globals
*/
extern Timer t_utils_timerSinceStart;
extern bool b_UTILS_flag_button_ESC;
extern bool b_UTILS_flag_button_SECTIONS;
extern bool b_UTILS_flag_emergency_stop;

extern InterruptIn b_UTILS_button;
extern InterruptIn b_UTILS_emergency_signal;
extern InterruptIn b_UTILS_startOnPin;

extern s_Section* s_UTILS_currentSection;


/*
Functions
*/
void it_pressed();
void it_emergency_signal_recieved();
void bubbleSort(double arr[], int n);
void swap(double *xp, double *yp);

#endif