#include "utils.h"
#include "log.h"

bool b_UTILS_flag_button_ESC = false;
bool b_UTILS_flag_button_SECTIONS = false;
bool b_UTILS_flag_emergency_stop = false;
Timer t_utils_timerSinceStart;
s_Section* s_UTILS_currentSection = NULL;

InterruptIn b_UTILS_button(USER_BUTTON);
InterruptIn b_UTILS_emergency_signal(PD_0);
InterruptIn b_UTILS_startOnPin(PD_1);

int i,j;

void it_pressed()
{
    if(t_utils_timerSinceStart.read_ms() > 500) {
        rs_LOG.printf("Button pressed; log ready: %d\r\n",b_LOG_READY);
        if(b_LOG_READY) {
            log_pc();
            b_LOG_READY = false;
        } else {
            t_utils_timerSinceStart.reset();
            b_UTILS_flag_button_SECTIONS = true;
            b_UTILS_flag_button_ESC = true;
            b_UTILS_flag_emergency_stop = false;
        }
    }
    return;
}

void it_emergency_signal_recieved()
{
    b_UTILS_flag_emergency_stop = true;
}

void bubbleSort(double arr[], int n)
{
    for (i = 0; i < n-1; i++) {
        // Last i elements are already in place
        for (j = 0; j < n-i-1; j++) {
            if (arr[j] > arr[j+1])  {
                swap(&arr[j], &arr[j+1]);
            }
        }
    }
}

void swap(double *xp, double *yp)
{
    double temp = *xp;
    *xp = *yp;
    *yp = temp;
}