#ifndef H_SM_SERVO
#define H_SM_SERVO

#include "utils.h"
#include "odom.h"

#define SERVO_PERIOD_DURATION_MS 20           //20ms is default but 10ms seems ok
#define SERVO_PULSE_MIDDLE_US 1500
#define SERVO_PULSE_MAX_US 2000
#define SERVO_PULSE_MIN_US 1050


/*
Enums
*/

typedef enum{
    SERVO_INIT,
    SERVO_COMMAND
}E_STATE_SERVO;

/*
Variables
*/

extern double d_SERVO_coefFreinage;

/*
Functions
*/
void init_sm_servo();
void update_sm_servo();
void output_sm_servo();

double compute_angle_correction(double consigne);
double pwmFromAngle(double angleDeg);
double positionOnTrack();

#endif