#include "sm_esc.h"
#include "sm_servo.h"
#include "sm_sections.h"
#include "sm_mpu.h"



int main()
{
    //on met le jumper sur le chassis le plus récent. Avec le jumper, b_CHASSIS_Mode = 0.
    init_chassis_mode();

    //init timers
    t_utils_timerSinceStart.start();

    //init_interruptions
    b_UTILS_button.fall(&it_pressed);
    b_UTILS_startOnPin.rise(&it_pressed);
    b_ODOM_odom.fall(&it_odom);
    b_UTILS_emergency_signal.rise(&it_emergency_signal_recieved);

    //init state machines
    rs_LOG.printf("init state machines\r\n");

    init_sm_mpu();
    init_sm_sections();
    init_sm_esc();
    init_sm_servo();

    while(1) {
        //rs_LOG_pc.printf("\r\n\r\nTIME: %d\r\n",t_utils_timerSinceStart.read_ms());

        update_sm_mpu();
        update_sm_sections();
        update_sm_esc();
        update_sm_servo();

        output_sm_mpu();
        output_sm_sections();
        output_sm_esc();
        output_sm_servo();
        
    }
}
