#ifndef H_LOG
#define H_LOG


#define LOG_SIZE 3000
#define LOG_PERIOD_MS 40
#include "mbed.h"

typedef struct sample {
   int timestamp;
   double left_90;
   double right_90;
   double left_45;
   double right_45;
   int pwm_dir;
   double odom;
   double speed;
   double angle_bord0;
   double angle_bord1;
   double angle_bord2;
   double angle_bord3;
   double angle_bord4;
   double angle_bord5;
   double angle_pos;
   double angle;
   double distParcourue;
}s_Sample;


void log_start(int duration_ms);
void log_check();
void log_stop();
void log_pc();
extern Serial rs_LOG;
extern bool b_LOG_READY;
extern s_Sample s_LOG_history[LOG_SIZE];
extern int i_LOG_index_data;


#endif