#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial device(A4,A5);  // tx, rx

int dist;// LiDAR actually measured distance value
int strength;// LiDAR signal strength
int check;// check numerical value storage
int i;
int uart[9];// store data measured by LiDAR
const int HEADER=0x59;// data package frame header

int main()
{
    pc.baud(115200);
    device.baud(115200);
    int i=0;
    pc.printf("Hello \n");
    while(1) {
        if (device.readable()) { //check whether the serial port has data input
            if(device.getc()==HEADER) { // determine data package frame header 0x59
                uart[0]=HEADER;
                if(device.getc()==HEADER) { //determine data package frame header 0x59
                    uart[1]=HEADER;
                    for(i=2; i<9; i++) { // store data to array
                        uart[i]=device.getc();
                    }
                    check=uart[0]+uart[1]+uart[2]+uart[3]+uart[4]+uart[5]+uart[6]+uart[7];
                    if(uart[8]==(check&0xff)) { // check the received data as per protocols
                        dist=uart[2]+uart[3]*256;// calculate distance value
                        strength=uart[4]+uart[5]*256;// calculate signal strength value
                        pc.printf("\rdist = %d strength = %d     ",dist,strength);// output signal strength value
                    }
                }
            }
        }
    }
}

