#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"


C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);
Timer t; 
AnalogIn simtemp (p19);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
Ticker periode;


volatile float dt;
volatile char flagtemp;
///////////////////////////////////////////////
//   fonction Flip pour gérer le timer 500ms

void flip(){
    dt=sensor.temp();
    flagtemp=1;
}


int main() {
       r.period(0.005);
       g.period(0.005);
       b.period(0.005);
       g=1.0;
       b=1.0;
       lcd.cls();
       if (sensor.open()) {
            pc.printf("Device detected!\n");
        }else {
            pc.printf("Device not detected!\n");
        }
        periode.attach(&flip, 0.5);
      // t.reset();
       while (1) {
            //tx.start()
                         //Print the current temperature
             if(flagtemp==1) {
                    pc.printf("Temp = %.3f\r\n", dt);
                    r = 1- (dt-25)/8.0 ;
                    flagtemp=0;
              }
       } 
}

//            lcd.copy_to_lcd();  // LCD.pixel does not update the lcd
//            wait_us(3000);
