/**
 * Copyright (c) 2015 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "XBeeLib.h"
#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
#endif

using namespace XBeeLib;

Serial *log_serial;

static void receive_cb(const RemoteXBee802& remote, bool broadcast, const uint8_t *const data, uint16_t len, const uint8_t rssi)
{
    if (remote.is_valid_addr16b()) {
        log_serial->printf("\r\nGot a %s 16-bit RX packet [%04x], RSSI: -%d dBm, len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr16(), rssi, len);
    } else {
        log_serial->printf("\r\nGot a %s 64-bit RX packet [%08x:%08x], RSSI: -%d dBm, len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr64(), rssi, len);
    }

    for (int i = 0; i < len; i++)
        log_serial->printf("%02x ", data[i]);

    log_serial->printf("\r\n");
}

int main()
{
    log_serial = new Serial(DEBUG_TX, DEBUG_RX);
    log_serial->baud(9600);
    log_serial->printf("Sample application to demo how to receive unicast and broadcast data with the XBee802\r\n\r\n");
    log_serial->printf(XB_LIB_BANNER);

#if defined(ENABLE_LOGGING)
    new DigiLoggerMbedSerial(log_serial, LogLevelInfo);
#endif

    XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);

    /* Register callback */
    xbee.register_receive_cb(&receive_cb);

    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);

    while (true) {
        xbee.process_rx_frames();
        wait_ms(100);
        log_serial->printf(".");
    }

    delete(log_serial);
}
