#include "mbed.h"
#include "eeprom.h"
 
EEPROM rom(I2C_SDA,I2C_SCL,0);
BusOut led(D2,D3,D4,D5,D6,D7,D8);
BusIn sw(A5,A4,A3,A2,A1,A0,D9);
DigitalIn Ck(D10),Mode(D11);

uint8_t write_address=0,read_address=0,size,data[]={};
int main() {
     while(1){

        if(Ck.read()){
            if(Mode.read()){ //Write
                if(read_address!=0){write_address=0;read_address=0;}
                
                rom.write(write_address,(uint8_t)sw.read());
                wait_ms(1);
                printf("Write Mode Data = %d  Address = %d\n",sw.read(),write_address);
                
                write_address++;
            }
            else{            //Read
                if(write_address!=0){
                    size=write_address-1;
                    read_address=0;
                    write_address=0;
                    }
                if(read_address>size){read_address=size;}
                rom.read(read_address,data,1);
                led=data[0];
                printf("Read Mode Data = %d Address = %d \n",data[0],read_address);

                read_address++;
                
                
            }
            while(Ck.read()){}
            wait(0.1);
        }
    }
}
