#include "mbed.h"
#include "Nextion.h"
 
Serial Display(PA_0, PA_1, 115200); //tx, rx, baud

int test = 0;
int CurrentPage = 0;
int temperature = 50;
int voltage = 116;

//Page 0 
NexButton b0 = NexButton(0, 1, "b0");   //Race
NexButton b1 = NexButton(0, 2, "b1");   //Test

//Page 1
NexButton b2 = NexButton(1, 5, "b0");   //Back
NexText t0 = NexText(1, 3, "t2");        //Temperature
NexText t1 = NexText(1, 4, "t3");        //Voltage

//Page 2
NexButton b3 = NexButton(2, 1, "b0");   //Back
NexText t2 = NexText(2, 2, "t0");        //test

//Declare Pages
NexPage page0 = NexPage(0, 0, "page0");  // Page added as a touch event
NexPage page1 = NexPage(1, 0, "page1");  // Page added as a touch event
NexPage page2 = NexPage(2, 0, "page2");  // Page added as a touch event

//End of declaring objects


// Declare touch event objects to the touch event list: 
// You just need to add the names of the objects that send a touch event.
// Format: &<object name>,

NexTouch *nex_listen_list[] = 
{
  &b0,  // Button added
  &b1,  // Button added
  &b2,  // Button added
  &b3,  // Button added
  &page0,  // Page added as a touch event
  &page1,  // Page added as a touch event
  &page2,  // Page added as a touch event
  NULL  // String terminated
};  // End of touch event list


////////////////////////// Touch events:
// Each of the following sections are going to run everytime the touch event happens:
// Is going to run the code inside each section only ones for each touch event.

void b0PushCallback(void *ptr)  // Press event for "Race" button on page 0
{
  Display.printf("page 1");  // Sending this it's going to tell the nextion display to go to page 1.
  Display.putc(0xff);  // We always have to send this three lines after each command sent to the nextion display.
  Display.putc(0xff);
  Display.putc(0xff);
}  // End of press event


void b1PushCallback(void *ptr)  // Press event for "Test" button on page 0
{
  Display.printf("page 2");  // Sending this it's going to tell the nextion display to go to page 2.
  Display.putc(0xff);  // We always have to send this three lines after each command sent to the nextion display.
  Display.putc(0xff);
  Display.putc(0xff);
}  // End of press event

void b2PushCallback(void *ptr)  // Press event for "Back" button on page 1
{
  Display.printf("page 0");  // Sending this it's going to tell the nextion display to go to page 0.
  Display.putc(0xff);  // We always have to send this three lines after each command sent to the nextion display.
  Display.putc(0xff);
  Display.putc(0xff);
}  // End of press event

void b3PushCallback(void *ptr)  // Press event for "Back" button on page 2
{
  Display.printf("page 0");  // Sending this it's going to tell the nextion display to go to page 0.
  Display.putc(0xff);  // We always have to send this three lines after each command sent to the nextion display.
  Display.putc(0xff);
  Display.putc(0xff);
}  // End of press event


// Page change event:
void page0PushCallback(void *ptr)  // If page 0 is loaded on the display, the following is going to execute:
{
  CurrentPage = 0;  // Set variable as 0 so from now on stm knows page 0 is loaded on the display
}  // End of press event


// Page change event:
void page1PushCallback(void *ptr)  // If page 1 is loaded on the display, the following is going to execute:
{
  CurrentPage = 1;  // Set variable as 1 so from now on stm knows page 1 is loaded on the display
}  // End of press event


// Page change event:
void page2PushCallback(void *ptr)  // If page 2 is loaded on the display, the following is going to execute:
{
  CurrentPage = 2;  // Set variable as 2 so from now on stm knows page 2 is loaded on the display
}  // End of press event

////////////////////////// End of touch events







int main() {
    // Register the event callback functions of each touch event:
    // You need to register press events and release events seperatly.
    // Format for press events: <object name>.attachPush(<object name>PushCallback);
    // Format for release events: <object name>.attachPop(<object name>PopCallback);
    b0.attachPush(b0PushCallback);  // Button press
    b1.attachPush(b1PushCallback);  // Button press
    b2.attachPush(b2PushCallback);  // Button press
    b3.attachPush(b3PushCallback);  // Button press
    page0.attachPush(page0PushCallback);  // Page press event
    page1.attachPush(page1PushCallback);  // Page press event
    page2.attachPush(page2PushCallback);  // Page press event
    
    // End of registering the event callback functions
    
    
    
    while(1){
        // Send page number to the object called np:
        // This object (np) exist on every page so at this point we don't need to check which page is loaded on the display.
        Display.printf("np.val=");  // This is sent to the nextion display to set what object name (before the dot) and what atribute (after the dot) are you going to change.
        Display.printf("%d", CurrentPage);  // This is the value you want to send to that object and atribute mentioned before.
        Display.putc(0xff);  // We always have to send this three lines after each command sent to the nextion display.
        Display.putc(0xff);
        Display.putc(0xff);
        
        if(CurrentPage == 1){
            temperature++;
            voltage--;
            wait(4);
            if(temperature == 70 || voltage == 0 ){
                temperature = 50;
                voltage = 116;
            } 
            //temperature        
            Display.printf("t2.txt");
            Display.printf("%d", temperature);
            Display.putc(0xff);
            Display.putc(0xff);        
            Display.putc(0xff);
            
            //voltage
            Display.printf("t3.txt");
            Display.printf("%d", voltage);
            Display.putc(0xff);
            Display.putc(0xff);        
            Display.putc(0xff);
        }
        
        if(CurrentPage == 2){
            test++;
            if(test == 100)
                test = 0;
            wait(2.0);   
            
            //test
            Display.printf("t0.txt");
            Display.printf("%d", test);
            Display.putc(0xff);
            Display.putc(0xff);        
            Display.putc(0xff); 
        }
        
        // We are going to check the list of touch events we enter previously to
        // know if any touch event just happened, and excecute the corresponding instructions:

        nexLoop(nex_listen_list);  // Check for any touch event

    }
}
