/* WS281XU.h (for LPC82X/STM32F0x/STM32F446/STM32F746xx)
 * mbed Microcontroller Library
 * Copyright (c) 2016 muetch, t.kuroki
 * Allrights reserved.
 *
 * Rev 0.97 2016-09-07
 * Rev 0.98 2016-09-08
 */

#pragma once

#ifndef WS281XU_H
#define WS281XU_H

//#include "mbed.h"
#include "PixelBuffer.h"

//----------------------------------------------------------------------------
/**
 * WS281XU
 */
class WS281XU : public RGBPixels
{
public:
    /**
        Order of r, g and b bytes
    */
    enum RGBOrder
    {
        RGB = 0, RBG, GRB, GBR, BRG, BGR
    };

    /**
    *   Initializes the addressable led bus
    *
    *   @param txPin - The output pin on wich the addressable leds are connected
    *   @param pinMode - The output pin mode PullUp, PullDown, PullNone, OpenDrain
    *   @param maxPixels - Number of the addressable leds
    *   @param RGBOrder - The order in wich the r, g and b bytes are expected
    */
    WS281XU(PinName txPin, PinMode pinMode = PullNone, int maxPixels = MAX_PIXELS, RGBOrder rgbOrder = WS281XU::RGB);
    WS281XU(PinName txPin, PinMode pinMode = PullNone, RGBColor *buffer = 0, int maxPixels = 0, RGBOrder rgbOrder = WS281XU::RGB);
    virtual ~WS281XU();

    RGBOrder rgbOrder() { return _rgb_order; }
    RGBOrder rgbOrder(RGBOrder order);

    void show();
    void show(const RGBColor color);

    bool irqEnabled() { return _irq_enabled; }
    bool irqEnabled(bool value) { return _irq_enabled = value; }

    RGBColor operator[](int index) const
    {
        if (_pixels && (uint16_t)index < _num_pixels)
            return _pixels[index];
        return _dummy_pixel;
    }

    RGBColor& operator[](int index)
    {
        if (_pixels && (uint16_t)index < _num_pixels)
            return _pixels[index];
        return _dummy_pixel;
    }

    operator RGBColor*() const { return _pixels; }

protected:
    void putByte(uint8_t c) { serial_putc(&_serial, c); }

private:
    PinName  _txPin;
    serial_t _serial;
    bool     _irq_enabled;
    RGBOrder _rgb_order;
    int      _1st, _2nd, _3rd;

#if defined(TARGET_STM)
    void pin_mode_ex(PinName pin, PinMode mode);
#endif
    void pin_init(PinName txPin, PinMode pinMode);
};

//----------------------------------------------------------------------------
#endif      // end of WS281XU_H
