/* WS281X.h (for LPC82X/STM32F0x/STM32F446/STM32F746xx)
 * mbed Microcontroller Library
 * Copyright (c) 2016 muetch, t.kuroki
 * Allrights reserved.
 *
 * Rev 0.97 2016-09-07
 * Rev 0.98 2016-09-08
 */

#pragma once

#ifndef WS281X_H
#define WS281X_H

//#include "mbed.h"
#include "PixelBuffer.h"

//----------------------------------------------------------------------------
/**
 * WS281X
 */
class WS281X : public RGBPixels
{
public:
    /**
        Order of r, g and b bytes
    */
    enum RGBOrder
    {
        RGB = 0, RBG, GRB, GBR, BRG, BGR
    };

    /**
    *   Initializes the addressable led bus
    *
    *   @param txPin - The output pin on wich the addressable leds are connected
    *   @param pinMode - The output pin mode PullUp, PullDown, PullNone, OpenDrain
    *   @param maxPixels - Number of the addressable leds
    *   @param RGBOrder - The order in wich the r, g and b bytes are expected
    */
    WS281X(PinName txPin, PinMode pinMode = PullNone, int maxPixels = MAX_PIXELS, RGBOrder rgbOrder = WS281X::RGB);
    WS281X(PinName txPin, PinMode pinMode = PullNone, RGBColor *buffer = 0, int maxPixels = 0, RGBOrder rgbOrder = WS281X::RGB);

    RGBOrder rgbOrder() { return _rgb_order; }
    RGBOrder rgbOrder(RGBOrder order);

    void show();
    void show(const RGBColor color);

    RGBColor operator[](int index) const
    {
        if (_pixels && (uint16_t)index < _num_pixels)
            return _pixels[index];
        return _dummy_pixel;
    }

    RGBColor& operator[](int index)
    {
        if (_pixels && (uint16_t)index < _num_pixels)
            return _pixels[index];
        return _dummy_pixel;
    }

    operator RGBColor*() const { return _pixels; }

protected:

private:
    PinName  _txPin;
    gpio_t   _gpio;
    RGBOrder _rgb_order;
    int _1st, _2nd, _3rd;

#if defined(TARGET_NXP)
    typedef uint32_t regsize_t;
#elif defined(TARGET_STM32F0) || defined(TARGET_STM32F1)
    typedef uint32_t regsize_t;
#elif defined(TARGET_STM)
    typedef uint16_t regsize_t;
#else
#error "not supported CPU!!"
#endif
#if defined(TARGET_STM)
    void pin_mode_ex(PinName pin, PinMode mode);
#endif
    void pin_init(PinName txPin, PinMode pinMode);
    void writeByte(__IO regsize_t *reg_set, __IO regsize_t *reg_clr, regsize_t *mask, uint8_t value);
};

//----------------------------------------------------------------------------
#endif      // end of WS281X_H
