#include "mbed.h"
#include "C12832.h"


//      LEDS
DigitalOut Led1(LED1, 0);
DigitalOut Led2(LED2, 0);
DigitalOut Led3(LED3, 0);
DigitalOut Led4(LED4, 0);

//      Joystick
InterruptIn  Sw1(p14);      // CENTER

//      Prototyping
void StateMachine();
//void ST_Error (void);
void ST_EIN (void);
void ST_AUS (void);
//void rise(void);
void Sw1Rise(void);
//bool CheckFlag() ;
bool CheckSw1(void);
void Time (void);
void TimeOut(void); 
void Flip (void);
void TempOut (void);
void TimeOutError(void);
void ErrorBlinken(void);
void TimeOver(void);

//bool pressed = false;
bool volatile Sw1Pressed;

//***** VARIABLEN ******

enum State {ST_AUS, ST_EIN, ST_Error};
//State state;
State volatile state;
Timer getTime; //Timer-Schnittstelle dient zum Erstellen, Starten, Stoppen und Lesen eines Timers 
Ticker TickFlip;//für blinken der LED     //wiederkehrenden Interrupt 
Timeout resetTime;//Die Timeout-Schnittstelle wird verwendet, um einen Interrupt 
                    //einzurichten, um eine Funktion nach einer bestimmten Verzögerung aufzurufen.

volatile int counter; // Volatile, damit es nicht auf unterschiedlichen Cores ausgeführt wird



class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p15) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

int main()
{
    
    Sw1.rise(&Sw1Rise);      //.fall(&fall)
    state = ST_AUS;
    Sw1Pressed = 0;
    Led1 = 0;
    Led2 = 0;
    Led3 = 0;
    Led4 = 0;
    counter=0;

    while(1)
    {
        
        StateMachine();
    }
}

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(50);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

    
void Sw1Rise(void) {
         if(state == ST_EIN || state == ST_AUS) {
            // wenn Taste getrückt wird wechsel je welcher status
            Sw1Pressed = true;// Umschalten auf WAHR, es wurde gedrückt
            wait_ms(200);
        }// Entprellung der Taste, bei mir 100ms da der Taster furchtbar prellt...
    } 

              
void StateMachine()  //mit den ganzen möglichen Statuse
{
    switch (state) 
    {
        case ST_AUS:          Aus()      ;break;
        case ST_EIN:          Ein()      ;break;
        case ST_TimeOut:      TimeOut()     ;break;
        case ST_TempOut:      TempOut()     ;break;
        case ST_Error:        TimeOver()    ;break;
                        
    }
}