#include "mbed.h"
#include "C12832.h"   //by Kevin Anderson
#include "LM75B.h"    //by Chris Styles


#define MAX_BUF 3

C12832 lcd(p5,p7,p6,p8,p11);
InterruptIn btn(p14);//Joystick Center
LM75B tmp(p28,p27);

EventQueue con_queue, pro_queue;
Thread consumer;
Thread producer;


class CircularBuffer1
{

private:
    Semaphore s_con, s_pro;
    Mutex mutex_con, mutex_pro;
    float buffer[MAX_BUF];
    int occupiedBufferCount;
    int readLocation;
    int writeLocation;

public:
    CircularBuffer1():s_con(0), s_pro(0)
    {
        occupiedBufferCount=0;
        readLocation=0;
        writeLocation=0;
    }
    float getBuffer()
    {
        mutex_con.lock();
        if (occupiedBufferCount == 0)
        {
            printf("Buffer empty\r\n");//Ausgabe HTerm
            s_pro.release();//Semaphore
            s_con.wait();        
        }
        
        float readValue = buffer[readLocation];
        occupiedBufferCount--;
        readLocation = (readLocation + 1) % MAX_BUF;
        mutex_con.unlock();
        return readValue;
    }
    void setBuffer(float value)
    {
        mutex_pro.lock();
        if (occupiedBufferCount == MAX_BUF)
        {
            printf("Buffer full\r\n");//Ausgabe HTerm
            s_con.release();//Semaphore
            s_pro.wait();
        }

        buffer[writeLocation] = value;
        printf("occupiedBufferCount: %i \n", occupiedBufferCount);//Ausgabe HTerm
        occupiedBufferCount++;
        writeLocation = (writeLocation + 1) % MAX_BUF;
        mutex_pro.unlock();

    }
};


CircularBuffer1 cb;

void consumer_worker()
{
    float temp = cb.getBuffer();
    printf("Temperatur: %.2f\n",temp);//Ausgabe HTerm
    lcd.locate(10,10); 
    lcd.printf("Temperatur: %.2f", temp);//Ausgabe LCD
    
}

void producer_worker()
{
    cb.setBuffer(tmp.read());//Class CircularBuffer1
}

void btn_pressed()
{
    con_queue.call(consumer_worker);//Event Queue Consumer
}

int main()
{
    btn.fall(&btn_pressed);//Joystick Center drücken
    pro_queue.call_every(1000, producer_worker);//jede Sekunde
    
    consumer.start(callback(&con_queue, &EventQueue::dispatch_forever));//Queue dispatch event ohne timeout
    producer.start(callback(&pro_queue, &EventQueue::dispatch_forever));
    
}
