/*
STM mit Klassen für 4 LEDs [BUSOUT verwenden - Vererbung]
vorgegebene Klasse IsAnEvent für Zustandsübergänge verwenden
sowie p14 für JoystickCenter

START:
4 Leds sollen für 500 ms leuchten und anschließend den initialisierten
Wert [0x03] ausgeben [die ersten beiden LEDs leichten]

EIN:
Nachdem Taste btn 3 Mal gedrückt wurde soll der Zustand EIN verlassen
werden und im Zustamd AUS alle 4 LEDs aus sein. Beim Verlassen des 
Zustands EIN soll Wert um 1 erhöht werden.

AUS:
Nachdem btn gedrückt wird soll wieder in Zustand EIN geschalten werden 
und der neue Wert an den LEDs angezeigt werden.

ENDE:
Durch Double-Klick des btn

*/

#include "mbed.h"


enum states {ST_START = 0, ST_EIN, ST_AUS, ST_ENDE};
volatile states state;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p15) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};
//------------------------------------------------------------------------------

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(50);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

IsAnEvent isanevent(p14);
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
class IsA : public BusOut
{
private:

public:
    IsA(PinName pin0, PinName pin1, PinName pin2, PinName pin3) : BusOut(pin0, pin1, pin2, pin3)
    {
        write(0);
    }

    void LedOff(void);
    void LedOn(void);
    void LedOn(int zahl);
};

//------------------------------------------------------------------------------
void IsA::LedOff(void)
{
    write(0);
}
void IsA::LedOn(void)
{
    write(15);
}
void IsA::LedOn(int zahl)
{
    write(zahl);
}

IsA isa(LED1, LED2, LED3, LED4);
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
class STM
{
private:
    Timer _timer;
    int _hexzahl;  
public:
    STM(int hexzahl):_hexzahl(hexzahl) {}

    void ST_Start(void);
    void ST_Ein(void);
    void ST_Aus(void);
    void ST_Ende(void);
};
//------------------------------------------------------------------------------
void STM::ST_Start(void)
{
    //entry
    printf("ST_Start \n");
    isa.LedOn();
    _timer.start();
    //do
    while(1)
    {
        if(_timer.read_ms() > 500)
        {
            state = ST_EIN;
            //exit
            _timer.stop();
            _timer.reset();
            return;
        }
    }
    
}
void STM::ST_Ein(void)
{
    printf("ST_Ein \n");
    int counter = 0;
    isa.LedOn(_hexzahl);
    while(1)
    {
        if(isanevent.CheckFlag())
        {
            counter++;
            if(counter == 3)
            {
                _hexzahl++;
                if(_hexzahl==16) _hexzahl = 0;  // Basis 16 -> von 0-15
                state = ST_AUS;
                return;
            }
        }
        
    }
    
    
}
void STM::ST_Aus(void)
{
    printf("ST_Aus \n");
    isa.LedOff();
    while(1)
    {
        if(isanevent.CheckFlag())
        {
            _timer.start();
            while(_timer.read_ms() < 1000)
            {
                if(isanevent.CheckFlag())
                {
                    _timer.stop();
                    _timer.reset();
                    state = ST_ENDE;
                    return;
                }
            }
            
            _timer.stop();
            _timer.reset();
            state = ST_EIN;
            return;
        }
    }
}
void STM::ST_Ende(void)
{
    printf("FIN \n");
    while(1)
    {
    }
}

STM stm(3);
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------


void statemachine(void)
{

     switch(state)
     {
        case ST_START:  stm.ST_Start();     break;
        case ST_EIN:    stm.ST_Ein();       break;
        case ST_AUS:    stm.ST_Aus();       break;
        case ST_ENDE:   stm.ST_Ende();      break;
        default:        printf("Error");    break;
     }
   
    
}

int main() 
{
    while(1)
    {
        statemachine();
    }
}
