
// Mit H-Term connecten 
// Debug über Konsole

#include "mbed.h"

class StateMachine
{
private:
    InterruptIn _sw1, _sw2, _sw3, _sw4;
    DigitalOut _led1, _led2, _led3, _led4;
    enum _State {ST_IDLE=0, ST_Blinken, ST_TimeOut};
    Timer _getTime;
    bool volatile _sw1Pressed;  // rechnet zu schnell als das cache korrekt ausgelesen wird
    bool volatile _sw2Pressed;
public:
    StateMachine(PinName sw1, PinName sw2, PinName sw3, PinName sw4, PinName led1, PinName led2, PinName led3, PinName led4):
    _sw1(sw1), _sw2(sw2), _sw3(sw3), _sw4(sw4), _led1(led1), _led2(led2), _led3(led3), _led4(led4)
    {
        _led1=0; _led2=0; _led3=0; _led4=0;
        _sw1.rise(callback(this, &StateMachine::sw1Rise));
        _sw2.rise(callback(this, &StateMachine::sw2Rise));
    }
public:
    _State state;
public:
    void init(void);
    void sw1Rise(void); void sw2Rise(void);
    void getTime(void);
    void statemachine(void);
    void idle(void); void blinken(void); void timeOut(void);
    bool sw1CheckFlag(void); bool sw2CheckFlag(void);
};

void StateMachine::init(void)
{
    printf("state - init \n");
    _sw1Pressed = false;
    _sw2Pressed = false;
    state = ST_IDLE;
}

bool StateMachine::sw2CheckFlag(void)
{
    if(_sw2Pressed == true) // Erweitern das es nicht im IDLE status gedrück werden kann
    {
        printf("state - sw2CheckFlag \n");
        _sw2Pressed = false;
        return true;
    } 
    return false;
}

void StateMachine::sw2Rise(void)
{
    printf("state - sw2Rise \n");
    _sw2Pressed = true;
    wait(0.2);
}

void StateMachine::timeOut(void)
{
    printf("state - timeOut \n \n");
    printf("TimeOut in Sekunden: ");
    int counter = 0;
    while(true)         // mit counter hängt Terminal immer 10 sekunden, eventuell mit TIcker machen
    {
        printf("%i ", counter++);
        wait(1);
        
        if(sw2CheckFlag())
        {
            state = ST_Blinken;
            return;
        }
        
    }
}

bool StateMachine::sw1CheckFlag(void)
{
    if(_sw1Pressed == true)
    {
        printf("state - sw1CheckFlag \n");
        _sw1Pressed = false;
        getTime();
        return true;
    }
    return false;
}

void StateMachine::sw1Rise(void)
{
    printf("state - sw1Rise \n");
    _sw1Pressed = true;
    wait(0.2);
}

void StateMachine::getTime(void)
{
    printf("state - getTime \n");
    if(_getTime.read() > 0)
    {
        printf("----------------------------\n");
        printf("Time passed: %.2f Sekunden  \n", _getTime.read());
        printf("----------------------------\n");
        printf("Timer - reset \n");
        _getTime.reset();
    }
    else
    {
        printf("Timer - start \n");
        _getTime.start();
    }
}

void StateMachine::statemachine(void)
{
    printf("state - menu \n");
    while(true)
    {
        switch(state)
        {
            case ST_IDLE:       idle();     break;   
            case ST_Blinken:    blinken();  break;
            case ST_TimeOut:    timeOut();  break;
            default: printf("ERROR \n");    break;
        }
    
    }

}

void StateMachine::idle(void)
{
    printf("state - idle \n \n");
    while(true)
    {
        if(sw1CheckFlag())
        {
            state = ST_Blinken;
            return;
        }
    }
    
}

void StateMachine::blinken(void)
{
    printf("state - blinken \n \n");
    _led1 = true;
    while(true)
    {
        _led4 = !_led4;
        wait(0.250);
        
        if(sw1CheckFlag())
        {
            state = ST_IDLE;
            _led1 = false;
            _led4 = false;
            return;
        }
        else if(sw2CheckFlag())
        {
            state = ST_TimeOut;
            return;
        }
    }
}



StateMachine statemachine(p14, p15, p12, p16, LED1, LED2, LED3, LED4);

int main() 
{
    printf("-------------------------------- \n");
    printf("| SERIAL - DEBUG  | PWR - 2019 | \n");
    printf("-------------------------------- \n");
    printf("main - 1 \n");
    statemachine.init();
    printf("main - 2 \n");
    statemachine.statemachine();
    printf("main - 3 \n");

}