#include "mbed.h"

// Uebung zu VIRTUELLE METHODEN
// SIEHE KOMMENTARE IM CODE
// Ausgabe SERIAL


// Virtuelle Methoden werden benötigt wenn Methoden der Basis Klasse von
// Methoden der abgeleiteten Klassen überschrieben werden. Und man später
// doch darauf zugreifen möchte Die Adressierung
// von einer virtuellen Methode wird erst zur Laufzeit über die V-Tabelle erledigt
// so kann man sie später umadressieren.

class BASE
{
public:
    BASE(int x) {}
    virtual void test(void)         // Virtuelle Methoden werden mit dem Prefix virtual gekennzeichnet
    {
        printf("Klasse BASE \n");
    }
};

class LIGHT : public BASE
{
public:
    LIGHT(int x):BASE(x) {}
    virtual void test(void)
    {
        printf("Klasse LIGHT \n");
    }
};

// Man erstellt einen Pointer der auf die Basisklasse zeigt und ändert dann 
// während der Laufzeit seine Adresse, einmal Basisklasse und einem Vererbte Klasse
// So kann dann die Methode ueber den Pointer aufgerufen werden, dessen Klassenadresse 
// im Pointer gespeichert ist 

BASE *pointer;
BASE base(3);
LIGHT light(7);

int main()
{
    pointer = &base;        // Adresse vom Objekt der Basisklasse
    pointer->test();        // Aufruf der Methode test() aus der Basisklasse
    pointer = &light;       // Adresse vom Objekt der Vererbten Klasse
    pointer->test();        // Aufruf der Methode test() aus der Vererbten Klasse

    return 0;
}
