#include "mbed.h"

// Uebung zu USING - Ausgabe per SERIAL
// Wichtig Kommentare im CODE


class A
{
public:
    A() {}
    // Methode Print wird erstellt
    void Print(char *r) 
    {
        printf("Klasse-A - %s \n", r);
    }

    // Methode Print wird überladen
    void Print(int anzahlt, char *r) 
    {
        printf("Klasse-A - %s - %i \n", r, anzahlt);
    }
};

class B : public A          // Klasse A wird auf Klasse B vererbt
{
public:
    B() {}
    // Print wird überschrieben und sperrt somit auch alle anderen überladenen
    // Methoden der Basisklasse
    void Print(char *nr)            
    {
        printf("Klasse-B - %s \n", nr);
    }
    // mit using werden die gesperrten Methoden der Basisklasse wieder sichtbar
    // Es kann nun die Überschriebene Methode der Vererbten Klasse gestartet werden
    // und zusätzlich die parametrisierbaren Methoden der Basisklasse
    using A::Print;

};


int main()
{
    A a;                    // Objekte zur Klasse erstellen
    B b;

    a.Print("a");           // Klasse A - ursprüngliche Methode
    a.Print(7, "a");        // Klasse A - überladene Methode
    b.Print("b");           // Klasse B - von Klasse A Überschriebene Methode
    b.Print(9, "b");        // Klasse A - durch using wird die urpsrüngliche überladene Methode 
                            //            von Klasse A verwendet
    return 0;               
}
