
/*
ANGABE
Schreiben Sie ein Programm für das M3 Board, dass einen Lichtschalter simuliert. 
Es soll LED1 nach betätigen des Schalters sw1 (Joy-Stick-Pins) ein bzw. ausgeschaltet 
werden (sie Interrupts, wobei Sie die Tasten-ISR nur für ein Flag verwenden dürfen, 
dass dem Programm ein Ein-/Ausschalten der Led signalisiert.


Weitere Aufgaben

Verwenden Sie für das Blinken der Led4 das Ticker Interface
Messen Sie die Zeit zwischen zwei Tastendrücken durch die Verwendung des Timer Interfaces
Fügen Sie den Zustand TimeOut hinzu (wie sieht das Zustandsdiagramm nun aus), der nach d
rücken der Taste SW2 aus dem Zustand Ein in diesen Zustand TimeOut wechselt und die gemessene 
Zeit im Sekundentakt auf die Serielle Schnittstelle schreibt.

Fügen Sie den Zustand TempOut hinzu (wie sieht das Zustandsdiagramm nun aus), 
der nach einem weiteren druck der Taste SW2 aus dem Zustand TimeOut in diesen 
Zustand TempOut wechselt und die Temperatur vom Temperatursensor LM75B im Sekundentakt 
auf die Serielle Schnittstelle schreibt. Durch nachmaliges drücken von SW2 soll wieder 
in den Zustand Ein geschaltet werden.

Erweitern Sie das Zustandsdiagramm um den Error-State: Wenn für 10 Sekunden 
keine Taste gedrückt wird soll in den Zustand (Error) verzweigt werden. Verwenden 
Sie dafür das Timeout Interface
*/



#include "mbed.h"
#include "LM75B.h"
// WICHTIG - SENSOR LIBRARY HINZUFÜGEN - von Chris Styles - die mit den meisten Hits


LM75B tmp(p28, p27);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn sw1(p14);       // JoyCenter
InterruptIn sw2(p15);       // JoyUp

// Prototyping 

void ON(void);
void IDLE(void);
void sw1Rise(void);
void sw2Rise(void);
bool checker(void);
bool checkersw2(void);
void time(void);
void timeOut(void);
void flipper(void);
void tempOut(void);
void timeOutError(void);
void errorBlinken(void);
void timeOver(void);

bool volatile sw1Pressed;       // Taster 1 pressed or not
bool volatile sw2Pressed;       // Taster 2 pressed or not
enum Status {ST_IDLE=0, ST_ON, ST_TimeOut, ST_TempOut, ST_Error};
Status volatile status;
Timer getTime;
Ticker tickerflipper;
Timeout removeTime;
int counter;


// Im main wird die Hauptschleife gestartet, welche mittels switch/case
// die verschiedenen Zustände abfragt und die zugehörige Funktion startet
// In jeder State-Funktion ist eine while Schleife die den eingabestatus
// abfragt nur bei positiver Rueckmeldung diese verlässt 
int main(void)
{
    sw1.rise(&sw1Rise);     // Interrupt
    sw2.rise(&sw2Rise);     // Interrupt
    
    // Initialisierung - Standard(START) Werte setzen
    status = ST_IDLE;
    sw1Pressed = 0; sw2Pressed = 0;
    led1 = 0; led2 = 0; led3 = 0; led4 = 0;
    counter = 0;
    
    
    // Diese while Schleife ist die Hauptschleife die nie verlassen wird
    // von ihr werden die Funktionen gestartet und in diesen wieder while 
    // Schleifen, so kommt man mit fast keinen Variablen aus
    while(1)
    {
        switch(status)
        {
            case ST_IDLE:       IDLE()          ; break;
            case ST_ON:         ON()            ; break;
            case ST_TimeOut:    timeOut()       ; break;
            case ST_TempOut:    tempOut()       ; break;
            case ST_Error:      timeOver()      ; break;
            default: printf("ERROR")            ; break;
        }
        
    }
}

// TIMEOUT
void timeOver(void)
{
    printf("Ende gut, Alles gut \n");
    while(1)
    {}
}

// Für den Error TIcker im Zusstand TimeOut
void errorBlinken(void)
{
    led4 = !led4;
}

void timeOutError(void)
{
    status = ST_Error;
    tickerflipper.attach(&errorBlinken, 0.3);
    printf("ERROR TIMEOUT \n");
    printf("Status: %i \n", status);

}

void tempOut(void)
{
    printf("void tempOut(void) \n");
    int countertemp = 0;
    while(1)
    {
        printf("%f \n", tmp.read());
        countertemp++;
        wait(1);
        
        if(checkersw2() == true)
        {
            status = ST_ON;
            return;
        }
    }
}

void timeOut(void)
{
    printf("void timeOut(void) \n");
    int counterto = 0;
    while(1)
    {
        printf("%i \n", counterto);
        counterto++;
        wait(1);
        if(checkersw2() == true)
        {
            status = ST_TempOut;
            return;
        }
    }  
}

void sw2Rise(void)
{
    printf("sw2Rise \n");
    if(status == ST_ON || status == ST_TimeOut || status == ST_TempOut)      sw2Pressed = true;
    wait(0.2);
}

bool checkersw2(void)
{
    if(sw2Pressed == true)
    {
        printf("chckersw2 \n");
        sw2Pressed = false;
        return true;
    }
    
    return false;
}

void time(void)
{
    printf("time(void) \n");
    if(getTime.read() == 0)     getTime.start();
    else
    {
        printf("Sekunden: %f \n", getTime.read());
        getTime.reset();
    }
}

bool checker(void)
{
    if(sw1Pressed == true)
    {
        printf("checker(void) \n");
        time();
        sw1Pressed = false;
        return true;
    }
    
    return false;
}

void sw1Rise(void)
{
    printf("sw1Rise(void) \n");
    if(status == ST_ON || status == ST_IDLE)    sw1Pressed = true;
    wait(0.2);
}

void ON(void)
{
    printf("ON(void) \n");
    tickerflipper.attach(&flipper, 0.5);
    removeTime.attach(&timeOutError, 10);
    led1 = true;
    while(1)
    {
        if(status == ST_Error)  
        {
            printf("ON verlassen \n");
            led1 = false;
            return;
        }

        if(checkersw2() == true)
        {
            status = ST_TimeOut;
            removeTime.detach();
            return;
        }
        
        if(checker() == true)
        {
            status = ST_IDLE;
            led1 = false;
            removeTime.detach();
            return;
        }
    }
}

void flipper(void)
{
    printf("void flipper(void) \n");
    
    led4 = !led4;

    if(counter == 3)
    {
        tickerflipper.detach();
        counter = 0;
    }
    else counter++;
}


void IDLE(void)
{
    removeTime.attach(&timeOutError, 10);
    printf("void IDLE(void) \n");
    while(1)
    {
        
        if(status == ST_Error)  
        {
            printf("IDLE verlassen \n");
            return;
        }
        if(checker() == true)
        {
            status = ST_ON;
            removeTime.detach();
            return;
        }
    }
}