#include "mbed.h"

// Uebung mit serieller Schnittstelle und Interrupts
// Ausgabe - SERIAL
// Programm wartet auf eine Eingabe, der String wird dann jeweils um
// die Eingabe erweitert
// RESET durch Eingabe von '.' [PUNKT]


class SerialEvent
{
private:
    Serial _connection;  
    bool _flag;
    int _x; 

public:
    SerialEvent(PinName tx, PinName rx): _connection(tx, rx)        // Construktor 
    {
        _connection.attach(callback(this, &SerialEvent::readSerial));
    }
    
    char content[200]; 
    
    void readSerial(void);
    bool checkFlag(void);
};


void SerialEvent::readSerial(void)
{
        if (_connection.readable()) content[_x] = _connection.getc();

        if (content[_x] == '.')
        {
            content[_x] = '\0';
            _x = 0;
            _flag = 0;
            

            int y = 0;
            while(content[y] != '\0')   
            {
                content[y] = '\0';
                y++;
            }
            y = 0;
        }
        else
        {
            _x++;
            _flag = 1;
        }   

}

bool SerialEvent::checkFlag(void)
{
    return _flag;
}

SerialEvent connectme(USBTX, USBRX);        // Neues Objekt erstellen und übergabe von TX und RX

int main() 
{
    // Ausgabe des momentanen Status sowie dem attachten String
    while(1)
    {
        printf("Flag Status: %i    String: %s \n", connectme.checkFlag(), connectme.content);
        wait_ms(200);
    }
}
