#include "mbed.h"

// Hardware Quadrature Encoder ABZ for Nucleo F401RE
// Output on debug port to host PC @ 9600 baud
// 
// By Nigel Webb, November 2014

/* Encoder Connections
   PA8 = CH1
   PA9 = CH2
   
   PA6 = CH1
   PA7 = CH2
*/


void EncoderInitialise(void) {
    // configure GPIO PA8 & PA9 as CH1 & CH2 inputs for Encoder1
    RCC->AHB1ENR |= 0x00000001;  // Enable clock for GPIOA
    GPIOA->MODER   |= GPIO_MODER_MODER8_1 | GPIO_MODER_MODER9_1 ;           //PA8 & PA9 as Alternate Function   /*!< GPIO port mode register,               Address offset: 0x00      */
    GPIOA->OTYPER  |= GPIO_OTYPER_OT_8 | GPIO_OTYPER_OT_9 ;                 //PA8 & PA9 as Inputs               /*!< GPIO port output type register,        Address offset: 0x04      */
    GPIOA->OSPEEDR |= GPIO_OSPEEDER_OSPEEDR8_1 | GPIO_OSPEEDER_OSPEEDR9_1 ; // High speed                        /*!< GPIO port output speed register,       Address offset: 0x08      */
    GPIOA->PUPDR   |= GPIO_PUPDR_PUPDR8_1 | GPIO_PUPDR_PUPDR9_1 ;           // Pull Down                        /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
    //GPIOA->AFR[0]  |= 0x11000000 ;                                          //  AF02 for PA8 & PA9              /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
    //GPIOA->AFR[1]  |= 0x00000011 ;                                          //                                  /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
   
    // configure GPIO PA6 & PA7 as CH1 & CH2 inputs for Encoder2
    RCC->AHB1ENR |= 0x00000001;  // Enable clock for GPIOA
    GPIOA->MODER   |= GPIO_MODER_MODER6_1 | GPIO_MODER_MODER7_1 ;           //PA6 & PA7 as Alternate Function   /*!< GPIO port mode register,               Address offset: 0x00      */
    GPIOA->OTYPER  |= GPIO_OTYPER_OT_6 | GPIO_OTYPER_OT_7 ;                 //PA6 & PA7 as Inputs               /*!< GPIO port output type register,        Address offset: 0x04      */
    GPIOA->OSPEEDR |= GPIO_OSPEEDER_OSPEEDR6_1 | GPIO_OSPEEDER_OSPEEDR7_1 ; // High speed                        /*!< GPIO port output speed register,       Address offset: 0x08      */
    GPIOA->PUPDR   |= GPIO_PUPDR_PUPDR6_1 | GPIO_PUPDR_PUPDR7_1 ;           // Pull Down                        /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
    GPIOA->AFR[0]  |= 0x22000000 ;                                          //  AF02 for PA6 & PA7              /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
    GPIOA->AFR[1]  |= 0x00000011 ;                                          //                                  /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */

    // configure TIM1 & TIM3 as Encoder input
    RCC->APB2ENR |= 0x00000001;  // Enable clock for TIM1
    RCC->APB1ENR |= 0x00000002;  // Enable clock for TIM3
    
    TIM1->CR1   = 0x0001;     // CEN(Counter ENable)='1'     < TIM control register 1
    TIM1->SMCR  = 0x0001;     // SMS='001' (Encoder mode 1)  < TIM CH2 Edge
    TIM1->CCMR1 = 0xF1F1;     // CC1S='01' CC2S='01'         < TIM capture/compare mode register 1
    TIM1->CCMR2 = 0x0000;     //                             < TIM capture/compare mode register 2
    TIM1->CCER  = 0x0011;     // CC1P CC2P                   < TIM capture/compare enable register
    TIM1->PSC   = 0x0000;     // Prescaler = (0+1)           < TIM prescaler
    TIM1->ARR   = 0x0000000a; // reload at 10                < TIM auto-reload register
    TIM1->CNT   = 0x0000;     //reset the counter before we use it
    
    TIM3->CR1   = 0x0001;     // CEN(Counter ENable)='1'     < TIM control register 1
    TIM3->SMCR  = 0x0001;     // SMS='001' (Encoder mode 1)  < TIM CH2 Edge
    TIM3->CCMR1 = 0xF1F1;     // CC1S='01' CC2S='01'         < TIM capture/compare mode register 1
    TIM3->CCMR2 = 0x0000;     //                             < TIM capture/compare mode register 2
    TIM3->CCER  = 0x0011;     // CC1P CC2P                   < TIM capture/compare enable register
    TIM3->PSC   = 0x0000;     // Prescaler = (0+1)           < TIM prescaler
    TIM3->ARR   = 0x0000000a; // reload at 10                < TIM auto-reload register 
    TIM3->CNT   = 0x0000;     //reset the counter before we use it  
       
}

int main() {
    
    printf("\e[1;1H\e[2J");
    EncoderInitialise() ;
    
    uint16_t count1=0, count2=0;
    
    while (1) {
        // Print Encoder count to debug port every 0.5 seconds
        count1 = TIM1->CNT ; // Get current position from Encoder1
        count2 = TIM3->CNT ; // Get current position from Encoder2
        printf("COUNT1 %d COUNT2 %d\r\n", count1, count2);
        wait(0.5);
    }
      
}