/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "stm32f4xx_hal_tim.h"

/* Private variables ---------------------------------------------------------*/
TIM_Encoder_InitTypeDef encoder1, encoder2;
TIM_HandleTypeDef timer1, timer2;

/* Private function prototypes -----------------------------------------------*/
void EncoderInit(TIM_Encoder_InitTypeDef * encoder, TIM_HandleTypeDef * timer, TIM_TypeDef * TIMx, uint32_t maxcount, uint32_t encmode);


Serial pc(USBTX, USBRX);

int main(void)
{
    uint16_t count1=0, count2=0;
    pc.printf("\e[1;1H\e[2J");

/* Initialize Timer as Encoder */
 
 EncoderInit(&encoder1, &timer1, TIM1, 65535, TIM_ENCODERMODE_TI2);
 EncoderInit(&encoder2, &timer2, TIM3, 65535, TIM_ENCODERMODE_TI2);
 
  while (1)
  {
    count1=__HAL_TIM_GET_COUNTER(&timer1); /* Read Counter Value */
    count2=__HAL_TIM_GET_COUNTER(&timer2); /* Read Counter Value */
    printf("COUNT1 %d COUNT2 %d\r\n", count1, count2);
    
    wait(0.1);
  }
}