#include "mbed.h"
#include "Ticker.h"
#include "BLE_Driver.h"
#include "MAX30100_RaivisStrogonovs.h"
#include "I2C_Driver.h"
#include "millis.h"

#define nRF51DK
//#define nRF52DK


#ifdef nRF52DK
#define SCL         28
#define SDA         29
#endif

#ifdef nRF51DK
#define SCL         7  
#define SDA         6
#endif


InterruptIn SMPRDY(p1);
DigitalOut LIVE_LED(p21, 1);
DigitalOut CONECT_LED(p22, 1);
DigitalOut TEST_LED(p23, 1);
DigitalOut LED(p24, 1);
DigitalIn TEST_BUTTON(p17,PullUp);

Ticker Flasher;
MAX30100* pulseOxymeter;

char show[10];

void callbackBLE(int event) {
    switch (event){
        case 1:     CONECT_LED = 1; break;
        case 2:     CONECT_LED = 0; break;
        default:    break;
        }
    }

void periodicCallback(void){
    uint8_t a;
    a = getBLE();  
    }

int main(void){
    millisStart();
    pulseoxymeter_t result;
    //SMPRDY.fall(&sample);
    Flasher.attach(periodicCallback, 1);
    ini_i2c(SCL, SDA);
    iniBLE("Sigfried");
    pulseOxymeter = new MAX30100( DEFAULT_OPERATING_MODE, DEFAULT_SAMPLING_RATE, DEFAULT_LED_PULSE_WIDTH, DEFAULT_IR_LED_CURRENT, true, true );
    while(1){
        result = pulseOxymeter->update();
        
        if( result.pulseDetected == true )
        {
            putBLE("Registers: \n");
            putBLE("BEAT");
    
            putBLE( "BPM: " );
            sprintf(show, "%f", result.heartBPM );
            putBLE(show);
            putBLE( " | " );
  
            putBLE( "SaO2: " );
            sprintf(show, "%f", result.SaO2 );
            putBLE(show);
            putBLE( "%" );

            putBLE("{P2|BPM|255,40,0|");
            sprintf(show, "%f", result.heartBPM );
            putBLE(show);
            putBLE("|SaO2|0,0,255|");
            sprintf(show, "%f", result.SaO2 );
            putBLE(show);
            putBLE("}");
            }
        }
    }
    

