/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "mbed.h"
#include "wire.h"

//#define BLE_Nano
#define nRF_51822


#ifdef nRF_51822
#define SCL         28
#define SDA         29
#endif

#ifdef BLE_Nano
#define SCL         7  
#define SDA         6
#endif

#define DEV_ADDR    0xB0

//Serial pc(USBTX, USBRX);
TwoWire Wire = TwoWire(NRF_TWI0);

int WriteBytes(uint8_t addr, uint8_t *pbuf, uint16_t length){

    Wire.beginTransmission(DEV_ADDR);
    //Wire.write( (uint8_t)addr>>8 );
    Wire.write( (uint8_t)addr );
    Wire.write(pbuf, length);
    return (Wire.endTransmission());
}

int ReadBytes(uint8_t addr, uint8_t *pbuf, uint16_t length){
    int error=0;
    Wire.beginTransmission(DEV_ADDR);
    //Wire.write( (uint8_t)addr>>8 );
    Wire.write( (uint8_t)addr );    
    error = Wire.endTransmission();
       
    Wire.requestFrom(DEV_ADDR+1, length);
    while( Wire.available() > 0 )
    {
        *pbuf = Wire.read();
        pbuf++;
    }
    return(error);
}


//static uint8_t wt_data[10] = {'H', 'e', 'l', 'l', 'o', 'W', 'o', 'r', 'l', 'd'};
//static uint8_t rd_data[10];

//static uint16_t index;

DigitalOut  led (p17);
DigitalIn   button(p13,PullUp);

int estado;
uint8_t address, data[3];


int main(void)
{
    int estado=0;
    led=1;
    data[0]=0;
    data[1]=0;
    data[2]=0;
    //pc.baud(9600);
    //wait(5);
    //Wire.begin();
    Wire.begin(SCL, SDA, TWI_FREQUENCY_100K);
    //pc.printf("IIC Demo Start \r\n");
    wait(0.1);
    while(1)
    {
        if (button==0) {
        estado = WriteBytes(0, data/*wt_data*/, 3);
        if (estado==0) {
            led=0;
        }
        else {
           led=1;
        }
            wait (0.5f);
        }
        //ReadBytes(0, rd_data, 10);     
        //pc.printf("Read data from AT24C512 \r\n");
        //for(index=0; index<10; index++)
        //{
        //    pc.putc(rd_data[index]);
        //    rd_data[index] = 0x00;
        //}
        //pc.printf("\r\n");
        //wait(1);
    }
}




















