/*

Programa de ejemplo para las librerías I2C
*/

#include "mbed.h"
#include "I2C_Driver.h"
#include "wire.h"

//#define nRF51DK
#define nRF52DK


#ifdef nRF52DK
#define SCL         28
#define SDA         29
#endif

#ifdef nRF51DK
#define SCL         7  
#define SDA         6
#endif

#define DEV_ADDR    0xB0


DigitalOut  led (p17);
DigitalIn   button(p13,PullUp);

int estado;
uint8_t address, data[3];

int main(void)
{
    led=1;
    data[0]=107;
    data[1]=0;
    data[2]=0;
    ini_i2c(SCL, SDA); //inicializacion del I2C
    wait(0.1);
    while(1)
    {
        if (button==0) {
            data[0]=0;
            //Parámetros write_i2c: addr: dirección de memoria; *pbuf: puntero de byte 0 del buffer; length: cantidad de bytes a enviar; dev_addr: Direección física del dispositivo esclavo i2c
            write_i2c(0, data, 3, DEV_ADDR);//debe escribirse en la dirección 0 de memoria el valor "0" para poder escribir en algún registro.
            data[0]=107;
            write_i2c(1, data, 3, DEV_ADDR);//durante la escritura, el byte menos significativo será el byte "0". Una escritura adecuada devuelve un "0".
            data[0]=1;
            write_i2c(0, data, 3, DEV_ADDR);//debe escribirse en la dirección 0 de memoria el valor "1" para poder leer algún registro.
            //wait (3);
            //Parámetros read_i2c: addr: dirección de memoria; *pbuf: puntero de byte 0 del buffer; length: cantidad de bytes a enviar; dev_addr: Direección física del dispositivo esclavo i2c
            if(read_i2c(1, data, 3, DEV_ADDR)==0)// durante la lectura, el byte menos significativo será el byte "0". Una lectura adecuada devuelve un "0".
                led=0;
            wait(0.5);
            led=1;
            wait(0.5);
            if(data[0]==107)
                led=0;
            else
                led=1;
            wait(0.5f);
        }
    }
}