#include "mbed.h"
#include "TLE5206_lib.h"

TLE5206::TLE5206(PinName IN1,PinName IN2):pwmIN1(IN1),pwmIN2(IN2){};

void TLE5206::setup(int periode_us){
    this->pwmIN1.period_us(periode_us);
    this->pwmIN2.period_us(periode_us);    
}

void TLE5206::write(float duty_cycle){
    if (duty_cycle < -TLE5206_SAT_HIGH){
        this->pwmIN1 = TLE5206_SAT_HIGH;
        this->pwmIN2 = 0.0;
    }else if (duty_cycle < -TLE5206_SAT_LOW){
        this->pwmIN1 = -duty_cycle;
        this->pwmIN2 = 0.0;
    }else if (duty_cycle < TLE5206_NO_SAT_LOW){
        this->pwmIN1 = TLE5206_SAT_LOW;
        this->pwmIN2 = 0.0;
    }else if (duty_cycle < 0){
        this->pwmIN1 = -TLE5206_SAT_LOW/TLE5206_NO_SAT_LOW*duty_cycle;
        this->pwmIN2 = 0.0;
    }else if (duty_cycle < TLE5206_NO_SAT_LOW){
        this->pwmIN1 = 0.0;
        this->pwmIN2 = TLE5206_SAT_LOW/TLE5206_NO_SAT_LOW*duty_cycle;
    }else if (duty_cycle < TLE5206_SAT_LOW){
        this->pwmIN1 = 0.0;
        this->pwmIN2 = TLE5206_SAT_LOW;
    }else if (duty_cycle < TLE5206_SAT_HIGH){
        this->pwmIN1 = 0.0;
        this->pwmIN2 = duty_cycle;
    }else {
        this->pwmIN1 = 0.0;
        this->pwmIN2 = TLE5206_SAT_HIGH;
    }
}