/**************************
 * 7366.h: 7366R header file
 **************************/
#ifndef DEF_SPI_7366
#define DEF_SPI_7366

//Count modes
#define NON_QUADRATURE 0
#define QUADRATURE_X1 0x01
#define QUADRATURE_X2 0x02
#define QUADRATURE_X4 0x03

//running mode
#define FREE_RUN 0
#define SINGE_CYCLE 0x04
#define RANGE_LIMIT 0x08
#define MODULO_N 0x0C

//Index modes
#define DISABLE_INDX 0
#define INDX_LOADC 0x10
#define INDX_RESET 0x20
#define INDX_LOADO 0x30

//Index synchronous modes
#define ASYNCH_INDX 0
#define SYNCH_INDX 0x80

//Clock filter modes
#define FILTER_1 0
#define FILTER_2 0x80

/* Valid flags- Any of these config words can be ORed together */
#define NO_FLAGS 0
#define IDX_FLAG 0x10
#define CMP_FLAG 0x20
#define BW_FLAG 0x40
#define CY_FLAG 0x80

//Register
#define MDR0 8
#define MDR1 16
#define DTR  24
#define CNTR 32
#define OTR  40
#define STR  48

//Instructions
#define CLR 0
#define RD	64
#define WR	128
#define LOAD 192

//Byte counter mode
#define CONFIG_4BYTES 0x00
#define CONFIG_3BYTES 0x01
#define CONFIG_2BYTES 0x02
#define CONFIG_1BYTES 0x03

//enable
#define CPT_ENABLE 0x00
#define CPT_DISABLE 0x04


#include "mbed.h"
 
 
 class SPI_7366 : public SPI
 {
 	public:
 		SPI_7366(PinName SPI_MOSI, PinName SPI_MISO, PinName SPI_SCLK,PinName SPI_SSEL);
 		void setup(void);
 		int32_t read_value(void);
 		void set_as_inverted(void);
 	protected:
 		DigitalOut select;
 		int sens; // 1 : normal / -1 : inverted
 	};
 
 
#endif
