#include "mbed.h"
#include "7366_lib.h"

SPI_7366::SPI_7366(PinName SPI_MOSI, PinName SPI_MISO, PinName SPI_SCLK, PinName SPI_SSEL):SPI(SPI_MOSI,SPI_MISO, SPI_SCLK),select(SPI_SSEL, 1){
	this->sens=1;
	}

void SPI_7366::setup(void){
	char rxBuffer[2];
	int rxLength = 0;
	int txLength = 2;
	char IR = WR|MDR0;
	char data = QUADRATURE_X1|FREE_RUN;
	char txBuffer[2] = {IR,data};
	this->lock();
	this->select = 0;
	this->write(txBuffer, txLength, rxBuffer, rxLength);
	this->select = 1;	
	this->unlock();

	
	IR = WR|MDR1;
	data = CONFIG_4BYTES|CPT_ENABLE;
	txBuffer[0] = IR;
	txBuffer[1] = data;
	this->lock();
	this->select = 0;
	this->write(txBuffer, txLength, rxBuffer, rxLength);
	this->select = 1;
	this->unlock();
	
	IR = CLR|CNTR;
	txBuffer[0] = IR;
	txLength = 1;
	this->lock();
	this->select = 0;
	this->write(txBuffer, txLength, rxBuffer, rxLength);
	this->select = 1;
	this->unlock();
	
	return;
	}
void SPI_7366::set_as_inverted(void){
	this->sens = -1;
	return;
}

int32_t SPI_7366::read_value(){
	char rxBuffer[6] = {0,0,0,0,0,0};
	char rxLength = 0;
	char IR = LOAD|OTR;
	char txBuffer[1] = {IR};
	int txLength = 1;
	this->lock();
	this->select = 0;
	this->write(txBuffer, txLength, rxBuffer, rxLength);
	this->select = 1;
	this->unlock();
	
	IR = RD|OTR;
	txBuffer[0] = IR;
	txLength = 1;
	rxLength = 5;
	this->lock();
	this->select = 0;
	this->write(txBuffer, txLength, rxBuffer, rxLength);
	this->select = 1;
	this->unlock();
	int32_t resultat = (rxBuffer[1]<<24) + (rxBuffer[2]<<16) + (rxBuffer[3]<<8) + (rxBuffer[4]<<0);
	return sens*resultat;
	}