#include "mbed.h"

PwmOut mypwm(PWM_OUT);
PwmOut Ipwm(PB_5);

DigitalOut myled(LED1);

int main() {
    //외부에 8MHz x-tal 부착해야 됨.
    mypwm.period_us(100);       //10KHz
    mypwm.pulsewidth_us(10);    //Duty rate: 10%
    
    Ipwm.period(0.0001);        //10KHz
    Ipwm.pulsewidth(0.000001);  //Duty rate: 1%, Duty rate는 1% 이하로 설정이 안됨.
  
    printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
    printf("Ipwm set to %.2f %%\r\n", Ipwm.read() * 100);
    printf("mypwm set to %.2f %%\r\n", mypwm.read() * 100);
    while(1) {
        myled = !myled;
        wait(1);
    }
}


//Nucleo의 경우 U2에서 외부 클럭을 감지하여 L053에 외부 클럭입력을 설정함.
//실 사용에서는 직접 클럭 설정을 하여야 함.
//cubeMx의 도움을 받아야 할 듯.