/*****************************************************************************
 * Project      : 7" TFT LCD 800x480 [AT070TN92]
 * Compiler     : mbed Online
 * Type         : Main
 * Comment      : Support mbed ST Nucleo Board. [Now on ST Nucleo F030R8]
 *              : Support Chip = SSD1963
 * File         : main.c
 *
 * Author       : Mr.Thongchai Artsamart [Bird Techstep]
 * E-Mail       : t.artsamart@gmail.com
 *              : tbird_th@hotmail.com
 * Start Date   : 20/03/2014 [dd/mm/yyyy]
 * Version Date : 20/03/2014 [dd/mm/yyyy]
 * Licensed under a Creative Commons Attribution-ShareAlike 3.0 License.
 *****************************************************************************
 * Remark    : Thank you -. no1wudi [CooCox]
 *                       -.
 *****************************************************************************/
#include "mbed.h"
#include "SSD1963.h"
//#include "stm32f4xx.h"

// Section : Define panel -----------------------------------------------------
#define LCD_W 800
#define LCD_H 480

// Section : Color define -----------------------------------------------------
#define ColorLightPink          255,182,193
#define ColorPink               255,192,203
#define ColorCrimson            220,20,60
#define ColorLavenderBlush      255,240,245
#define ColorHotPink            255,105,180
#define ColorDeepPink           255,20,147
#define ColorMediumVioletRed    199,21,133
#define ColorOrchid             218,112,214
#define ColorPurple             128,0,128
#define ColorBlue               0,0,255
#define ColorYellow             255,255,0
#define ColorOlive              128,128,0
#define ColorGreen              0,255,0
#define ColorGold               215,215,0
#define ColorOrange             255,165,0
#define ColorRed                255,0,0
#define ColorWhite              255,255,255
#define ColorBlack              0,0,0
#define ColorGlay               128,128,128
// End : Color define ---------------------------------------------------------

// Section : Pins Connect -----------------------------------------------------
// Bus PortC
// RS PA_15
// WR PA_14
// RD PA_13
// CS PA_12
// RESET PA_11

// Test Fast IO in PortC ------------------------------------------------------
//#define LCD_PIN_RESET  GPIOA,GPIO_Pin_11
//#define LCD_PIN_nCS    GPIOA,GPIO_Pin_12
//#define LCD_PIN_nRD    GPIOA,GPIO_Pin_13
//#define LCD_PIN_nWR    GPIOA,GPIO_Pin_14
//#define LCD_PIN_nRS    GPIOA,GPIO_Pin_15
// End Test Fast IO in PortC --------------------------------------------------

//PortInOut LCD_BUS(PortC, 0xFFFF);
//BusInOut  LCD_BUS(PC_0,PC_1,PC_2,PC_3,PC_4,PC_5,PC_6,PC_7,PC_8,PC_9,PC_10,PC_11,PC_12,PC_13,PC_14,PC_15);
//#define LCD_RESET PA_11
//#define LCD_nCS   PA_12
//#define LCD_nRD   PA_13
//#define LCD_nWR   PA_14
//#define LCD_nRS   PA_15
//DigitalOut LCD_RESET(PA_11);
//DigitalOut LCD_nCS(PA_12);
//DigitalOut LCD_nRD(PA_13);
//DigitalOut LCD_nWR(PA_14);
//DigitalOut LCD_nRS(PA_15);
// End : Pins Connect ---------------------------------------------------------

//SSD1963 MyTFT(LCD_nRS, LCD_nWR, LCD_nRD, LCD_nCS, LCD_RESET, &LCD_BUS);
//Serial pc(SERIAL_TX, SERIAL_RX);
SSD1963 MyTFT;

// define timer ms ------------------------------------------------------------
#define timer_ms 1000
//=======================================
int main(void) {
    /*
    MyTFT.writeCommand(0x0000);  uint16_t tftID = MyTFT.readData();
    pc.printf("\n \r");
    pc.printf("Hello World! Bird Techstep\n \r");
    pc.printf("TFT LCD Chip No. : ");
    pc.printf("0x%04x", tftID);
    pc.printf("\n \r");
    // Use GPIOC->ODR = Output or GPIOC->IDR = Input
    */
    //MyTFT.init();
    MyTFT.begin();
   
    while(1)
    {
        MyTFT.fillScreen(MyTFT.Color565(ColorBlack));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorGlay));
        wait_ms(timer_ms);

        MyTFT.fillScreen(MyTFT.Color565(ColorLightPink));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorPink));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorCrimson));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorLavenderBlush));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorHotPink));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorDeepPink));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorMediumVioletRed));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorOrchid));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorPurple));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorWhite));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorBlue));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorYellow));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorOlive));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorGreen));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorGold));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorOrange));
        wait_ms(timer_ms);
        MyTFT.fillScreen(MyTFT.Color565(ColorRed));
        wait_ms(timer_ms);
        
    }
}
