#include "mbed.h"

//SPI Slave
SPISlave device(D11, D12, D13, D10); // mosi, miso, sclk, ssel //nope
Serial pc(USBTX, USBRX); 
DigitalOut ir(D9);

uint8_t spi_reply_blocking(uint8_t reply = 0x00, bool sendIr = 0) {
    device.reply(reply);
    if(sendIr) {
        ir = 1; 
        printf("ir sent\r\n"); 
        ir = 0;
    }
    
    while(!device.receive()) {}
    
    return device.read();  
}

int main() {
    ir = 0; 
    pc.baud(9600);
    printf("init\r\n");
     
    device.format(8, 1);
    device.frequency(1000000);
     
          
    while(1) { 
        int pass = 0; 
        int fail = 0;
        int miss = 0;
        
        for (uint8_t keystroke = 16; keystroke < 116; keystroke++) {
            
            if(spi_reply_blocking(0, 1) == 0xFE) {
                spi_reply_blocking(keystroke);
                
                if(spi_reply_blocking() != keystroke) {
                    fail++;
                } else {
                    pass++;    
                }           
            } else {
                miss++;    
            }
            
            printf("fail: %d pass: %d missed: %d. press any key.\r\n", fail, pass, miss);
            pc.getc();
            
        }
        
        
        
     }   
 }
