/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_RTC_REGISTERS_H__
#define __HW_RTC_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 RTC
 *
 * Secure Real Time Clock
 *
 * Registers defined in this header file:
 * - HW_RTC_TSR - RTC Time Seconds Register
 * - HW_RTC_TPR - RTC Time Prescaler Register
 * - HW_RTC_TAR - RTC Time Alarm Register
 * - HW_RTC_TCR - RTC Time Compensation Register
 * - HW_RTC_CR - RTC Control Register
 * - HW_RTC_SR - RTC Status Register
 * - HW_RTC_LR - RTC Lock Register
 * - HW_RTC_IER - RTC Interrupt Enable Register
 * - HW_RTC_WAR - RTC Write Access Register
 * - HW_RTC_RAR - RTC Read Access Register
 *
 * - hw_rtc_t - Struct containing all module registers.
 */

#define HW_RTC_INSTANCE_COUNT (1U) /*!< Number of instances of the RTC module. */

/*******************************************************************************
 * HW_RTC_TSR - RTC Time Seconds Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_TSR - RTC Time Seconds Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tsr
{
    uint32_t U;
    struct _hw_rtc_tsr_bitfields
    {
        uint32_t TSR : 32;             /*!< [31:0] Time Seconds Register */
    } B;
} hw_rtc_tsr_t;

/*!
 * @name Constants and macros for entire RTC_TSR register
 */
/*@{*/
#define HW_RTC_TSR_ADDR(x)       ((x) + 0x0U)

#define HW_RTC_TSR(x)            (*(__IO hw_rtc_tsr_t *) HW_RTC_TSR_ADDR(x))
#define HW_RTC_TSR_RD(x)         (HW_RTC_TSR(x).U)
#define HW_RTC_TSR_WR(x, v)      (HW_RTC_TSR(x).U = (v))
#define HW_RTC_TSR_SET(x, v)     (HW_RTC_TSR_WR(x, HW_RTC_TSR_RD(x) |  (v)))
#define HW_RTC_TSR_CLR(x, v)     (HW_RTC_TSR_WR(x, HW_RTC_TSR_RD(x) & ~(v)))
#define HW_RTC_TSR_TOG(x, v)     (HW_RTC_TSR_WR(x, HW_RTC_TSR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_TSR bitfields
 */

/*!
 * @name Register RTC_TSR, field TSR[31:0] (RW)
 *
 * When the time counter is enabled, the TSR is read only and increments once a
 * second provided SR[TOF] or SR[TIF] are not set. The time counter will read as
 * zero when SR[TOF] or SR[TIF] are set. When the time counter is disabled, the
 * TSR can be read or written. Writing to the TSR when the time counter is
 * disabled will clear the SR[TOF] and/or the SR[TIF]. Writing to TSR with zero is
 * supported, but not recommended because TSR will read as zero when SR[TIF] or
 * SR[TOF] are set (indicating the time is invalid).
 */
/*@{*/
#define BP_RTC_TSR_TSR       (0U)          /*!< Bit position for RTC_TSR_TSR. */
#define BM_RTC_TSR_TSR       (0xFFFFFFFFU) /*!< Bit mask for RTC_TSR_TSR. */
#define BS_RTC_TSR_TSR       (32U)         /*!< Bit field size in bits for RTC_TSR_TSR. */

/*! @brief Read current value of the RTC_TSR_TSR field. */
#define BR_RTC_TSR_TSR(x)    (HW_RTC_TSR(x).U)

/*! @brief Format value for bitfield RTC_TSR_TSR. */
#define BF_RTC_TSR_TSR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_TSR_TSR) & BM_RTC_TSR_TSR)

/*! @brief Set the TSR field to a new value. */
#define BW_RTC_TSR_TSR(x, v) (HW_RTC_TSR_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_RTC_TPR - RTC Time Prescaler Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_TPR - RTC Time Prescaler Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tpr
{
    uint32_t U;
    struct _hw_rtc_tpr_bitfields
    {
        uint32_t TPR : 16;             /*!< [15:0] Time Prescaler Register */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_rtc_tpr_t;

/*!
 * @name Constants and macros for entire RTC_TPR register
 */
/*@{*/
#define HW_RTC_TPR_ADDR(x)       ((x) + 0x4U)

#define HW_RTC_TPR(x)            (*(__IO hw_rtc_tpr_t *) HW_RTC_TPR_ADDR(x))
#define HW_RTC_TPR_RD(x)         (HW_RTC_TPR(x).U)
#define HW_RTC_TPR_WR(x, v)      (HW_RTC_TPR(x).U = (v))
#define HW_RTC_TPR_SET(x, v)     (HW_RTC_TPR_WR(x, HW_RTC_TPR_RD(x) |  (v)))
#define HW_RTC_TPR_CLR(x, v)     (HW_RTC_TPR_WR(x, HW_RTC_TPR_RD(x) & ~(v)))
#define HW_RTC_TPR_TOG(x, v)     (HW_RTC_TPR_WR(x, HW_RTC_TPR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_TPR bitfields
 */

/*!
 * @name Register RTC_TPR, field TPR[15:0] (RW)
 *
 * When the time counter is enabled, the TPR is read only and increments every
 * 32.768 kHz clock cycle. The time counter will read as zero when SR[TOF] or
 * SR[TIF] are set. When the time counter is disabled, the TPR can be read or
 * written. The TSR[TSR] increments when bit 14 of the TPR transitions from a logic one
 * to a logic zero.
 */
/*@{*/
#define BP_RTC_TPR_TPR       (0U)          /*!< Bit position for RTC_TPR_TPR. */
#define BM_RTC_TPR_TPR       (0x0000FFFFU) /*!< Bit mask for RTC_TPR_TPR. */
#define BS_RTC_TPR_TPR       (16U)         /*!< Bit field size in bits for RTC_TPR_TPR. */

/*! @brief Read current value of the RTC_TPR_TPR field. */
#define BR_RTC_TPR_TPR(x)    (HW_RTC_TPR(x).B.TPR)

/*! @brief Format value for bitfield RTC_TPR_TPR. */
#define BF_RTC_TPR_TPR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_TPR_TPR) & BM_RTC_TPR_TPR)

/*! @brief Set the TPR field to a new value. */
#define BW_RTC_TPR_TPR(x, v) (HW_RTC_TPR_WR(x, (HW_RTC_TPR_RD(x) & ~BM_RTC_TPR_TPR) | BF_RTC_TPR_TPR(v)))
/*@}*/

/*******************************************************************************
 * HW_RTC_TAR - RTC Time Alarm Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_TAR - RTC Time Alarm Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tar
{
    uint32_t U;
    struct _hw_rtc_tar_bitfields
    {
        uint32_t TAR : 32;             /*!< [31:0] Time Alarm Register */
    } B;
} hw_rtc_tar_t;

/*!
 * @name Constants and macros for entire RTC_TAR register
 */
/*@{*/
#define HW_RTC_TAR_ADDR(x)       ((x) + 0x8U)

#define HW_RTC_TAR(x)            (*(__IO hw_rtc_tar_t *) HW_RTC_TAR_ADDR(x))
#define HW_RTC_TAR_RD(x)         (HW_RTC_TAR(x).U)
#define HW_RTC_TAR_WR(x, v)      (HW_RTC_TAR(x).U = (v))
#define HW_RTC_TAR_SET(x, v)     (HW_RTC_TAR_WR(x, HW_RTC_TAR_RD(x) |  (v)))
#define HW_RTC_TAR_CLR(x, v)     (HW_RTC_TAR_WR(x, HW_RTC_TAR_RD(x) & ~(v)))
#define HW_RTC_TAR_TOG(x, v)     (HW_RTC_TAR_WR(x, HW_RTC_TAR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_TAR bitfields
 */

/*!
 * @name Register RTC_TAR, field TAR[31:0] (RW)
 *
 * When the time counter is enabled, the SR[TAF] is set whenever the TAR[TAR]
 * equals the TSR[TSR] and the TSR[TSR] increments. Writing to the TAR clears the
 * SR[TAF].
 */
/*@{*/
#define BP_RTC_TAR_TAR       (0U)          /*!< Bit position for RTC_TAR_TAR. */
#define BM_RTC_TAR_TAR       (0xFFFFFFFFU) /*!< Bit mask for RTC_TAR_TAR. */
#define BS_RTC_TAR_TAR       (32U)         /*!< Bit field size in bits for RTC_TAR_TAR. */

/*! @brief Read current value of the RTC_TAR_TAR field. */
#define BR_RTC_TAR_TAR(x)    (HW_RTC_TAR(x).U)

/*! @brief Format value for bitfield RTC_TAR_TAR. */
#define BF_RTC_TAR_TAR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_TAR_TAR) & BM_RTC_TAR_TAR)

/*! @brief Set the TAR field to a new value. */
#define BW_RTC_TAR_TAR(x, v) (HW_RTC_TAR_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_RTC_TCR - RTC Time Compensation Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_TCR - RTC Time Compensation Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tcr
{
    uint32_t U;
    struct _hw_rtc_tcr_bitfields
    {
        uint32_t TCR : 8;              /*!< [7:0] Time Compensation Register */
        uint32_t CIR : 8;              /*!< [15:8] Compensation Interval Register */
        uint32_t TCV : 8;              /*!< [23:16] Time Compensation Value */
        uint32_t CIC : 8;              /*!< [31:24] Compensation Interval Counter */
    } B;
} hw_rtc_tcr_t;

/*!
 * @name Constants and macros for entire RTC_TCR register
 */
/*@{*/
#define HW_RTC_TCR_ADDR(x)       ((x) + 0xCU)

#define HW_RTC_TCR(x)            (*(__IO hw_rtc_tcr_t *) HW_RTC_TCR_ADDR(x))
#define HW_RTC_TCR_RD(x)         (HW_RTC_TCR(x).U)
#define HW_RTC_TCR_WR(x, v)      (HW_RTC_TCR(x).U = (v))
#define HW_RTC_TCR_SET(x, v)     (HW_RTC_TCR_WR(x, HW_RTC_TCR_RD(x) |  (v)))
#define HW_RTC_TCR_CLR(x, v)     (HW_RTC_TCR_WR(x, HW_RTC_TCR_RD(x) & ~(v)))
#define HW_RTC_TCR_TOG(x, v)     (HW_RTC_TCR_WR(x, HW_RTC_TCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_TCR bitfields
 */

/*!
 * @name Register RTC_TCR, field TCR[7:0] (RW)
 *
 * Configures the number of 32.768 kHz clock cycles in each second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 *
 * Values:
 * - 10000000 - Time Prescaler Register overflows every 32896 clock cycles.
 * - 11111111 - Time Prescaler Register overflows every 32769 clock cycles.
 * - 0 - Time Prescaler Register overflows every 32768 clock cycles.
 * - 1 - Time Prescaler Register overflows every 32767 clock cycles.
 * - 1111111 - Time Prescaler Register overflows every 32641 clock cycles.
 */
/*@{*/
#define BP_RTC_TCR_TCR       (0U)          /*!< Bit position for RTC_TCR_TCR. */
#define BM_RTC_TCR_TCR       (0x000000FFU) /*!< Bit mask for RTC_TCR_TCR. */
#define BS_RTC_TCR_TCR       (8U)          /*!< Bit field size in bits for RTC_TCR_TCR. */

/*! @brief Read current value of the RTC_TCR_TCR field. */
#define BR_RTC_TCR_TCR(x)    (HW_RTC_TCR(x).B.TCR)

/*! @brief Format value for bitfield RTC_TCR_TCR. */
#define BF_RTC_TCR_TCR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_TCR_TCR) & BM_RTC_TCR_TCR)

/*! @brief Set the TCR field to a new value. */
#define BW_RTC_TCR_TCR(x, v) (HW_RTC_TCR_WR(x, (HW_RTC_TCR_RD(x) & ~BM_RTC_TCR_TCR) | BF_RTC_TCR_TCR(v)))
/*@}*/

/*!
 * @name Register RTC_TCR, field CIR[15:8] (RW)
 *
 * Configures the compensation interval in seconds from 1 to 256 to control how
 * frequently the TCR should adjust the number of 32.768 kHz cycles in each
 * second. The value written should be one less than the number of seconds. For
 * example, write zero to configure for a compensation interval of one second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 */
/*@{*/
#define BP_RTC_TCR_CIR       (8U)          /*!< Bit position for RTC_TCR_CIR. */
#define BM_RTC_TCR_CIR       (0x0000FF00U) /*!< Bit mask for RTC_TCR_CIR. */
#define BS_RTC_TCR_CIR       (8U)          /*!< Bit field size in bits for RTC_TCR_CIR. */

/*! @brief Read current value of the RTC_TCR_CIR field. */
#define BR_RTC_TCR_CIR(x)    (HW_RTC_TCR(x).B.CIR)

/*! @brief Format value for bitfield RTC_TCR_CIR. */
#define BF_RTC_TCR_CIR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_TCR_CIR) & BM_RTC_TCR_CIR)

/*! @brief Set the CIR field to a new value. */
#define BW_RTC_TCR_CIR(x, v) (HW_RTC_TCR_WR(x, (HW_RTC_TCR_RD(x) & ~BM_RTC_TCR_CIR) | BF_RTC_TCR_CIR(v)))
/*@}*/

/*!
 * @name Register RTC_TCR, field TCV[23:16] (RO)
 *
 * Current value used by the compensation logic for the present second interval.
 * Updated once a second if the CIC equals 0 with the contents of the TCR field.
 * If the CIC does not equal zero then it is loaded with zero (compensation is
 * not enabled for that second increment).
 */
/*@{*/
#define BP_RTC_TCR_TCV       (16U)         /*!< Bit position for RTC_TCR_TCV. */
#define BM_RTC_TCR_TCV       (0x00FF0000U) /*!< Bit mask for RTC_TCR_TCV. */
#define BS_RTC_TCR_TCV       (8U)          /*!< Bit field size in bits for RTC_TCR_TCV. */

/*! @brief Read current value of the RTC_TCR_TCV field. */
#define BR_RTC_TCR_TCV(x)    (HW_RTC_TCR(x).B.TCV)
/*@}*/

/*!
 * @name Register RTC_TCR, field CIC[31:24] (RO)
 *
 * Current value of the compensation interval counter. If the compensation
 * interval counter equals zero then it is loaded with the contents of the CIR. If the
 * CIC does not equal zero then it is decremented once a second.
 */
/*@{*/
#define BP_RTC_TCR_CIC       (24U)         /*!< Bit position for RTC_TCR_CIC. */
#define BM_RTC_TCR_CIC       (0xFF000000U) /*!< Bit mask for RTC_TCR_CIC. */
#define BS_RTC_TCR_CIC       (8U)          /*!< Bit field size in bits for RTC_TCR_CIC. */

/*! @brief Read current value of the RTC_TCR_CIC field. */
#define BR_RTC_TCR_CIC(x)    (HW_RTC_TCR(x).B.CIC)
/*@}*/

/*******************************************************************************
 * HW_RTC_CR - RTC Control Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_CR - RTC Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_cr
{
    uint32_t U;
    struct _hw_rtc_cr_bitfields
    {
        uint32_t SWR : 1;              /*!< [0] Software Reset */
        uint32_t WPE : 1;              /*!< [1] Wakeup Pin Enable */
        uint32_t SUP : 1;              /*!< [2] Supervisor Access */
        uint32_t UM : 1;               /*!< [3] Update Mode */
        uint32_t WPS : 1;              /*!< [4] Wakeup Pin Select */
        uint32_t RESERVED0 : 3;        /*!< [7:5]  */
        uint32_t OSCE : 1;             /*!< [8] Oscillator Enable */
        uint32_t CLKO : 1;             /*!< [9] Clock Output */
        uint32_t SC16P : 1;            /*!< [10] Oscillator 16pF Load Configure */
        uint32_t SC8P : 1;             /*!< [11] Oscillator 8pF Load Configure */
        uint32_t SC4P : 1;             /*!< [12] Oscillator 4pF Load Configure */
        uint32_t SC2P : 1;             /*!< [13] Oscillator 2pF Load Configure */
        uint32_t RESERVED1 : 18;       /*!< [31:14]  */
    } B;
} hw_rtc_cr_t;

/*!
 * @name Constants and macros for entire RTC_CR register
 */
/*@{*/
#define HW_RTC_CR_ADDR(x)        ((x) + 0x10U)

#define HW_RTC_CR(x)             (*(__IO hw_rtc_cr_t *) HW_RTC_CR_ADDR(x))
#define HW_RTC_CR_RD(x)          (HW_RTC_CR(x).U)
#define HW_RTC_CR_WR(x, v)       (HW_RTC_CR(x).U = (v))
#define HW_RTC_CR_SET(x, v)      (HW_RTC_CR_WR(x, HW_RTC_CR_RD(x) |  (v)))
#define HW_RTC_CR_CLR(x, v)      (HW_RTC_CR_WR(x, HW_RTC_CR_RD(x) & ~(v)))
#define HW_RTC_CR_TOG(x, v)      (HW_RTC_CR_WR(x, HW_RTC_CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_CR bitfields
 */

/*!
 * @name Register RTC_CR, field SWR[0] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Resets all RTC registers except for the SWR bit and the RTC_WAR and
 *     RTC_RAR registers . The SWR bit is cleared by VBAT POR and by software
 *     explicitly clearing it.
 */
/*@{*/
#define BP_RTC_CR_SWR        (0U)          /*!< Bit position for RTC_CR_SWR. */
#define BM_RTC_CR_SWR        (0x00000001U) /*!< Bit mask for RTC_CR_SWR. */
#define BS_RTC_CR_SWR        (1U)          /*!< Bit field size in bits for RTC_CR_SWR. */

/*! @brief Read current value of the RTC_CR_SWR field. */
#define BR_RTC_CR_SWR(x)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SWR))

/*! @brief Format value for bitfield RTC_CR_SWR. */
#define BF_RTC_CR_SWR(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SWR) & BM_RTC_CR_SWR)

/*! @brief Set the SWR field to a new value. */
#define BW_RTC_CR_SWR(x, v)  (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SWR) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field WPE[1] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin is disabled.
 * - 1 - Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 */
/*@{*/
#define BP_RTC_CR_WPE        (1U)          /*!< Bit position for RTC_CR_WPE. */
#define BM_RTC_CR_WPE        (0x00000002U) /*!< Bit mask for RTC_CR_WPE. */
#define BS_RTC_CR_WPE        (1U)          /*!< Bit field size in bits for RTC_CR_WPE. */

/*! @brief Read current value of the RTC_CR_WPE field. */
#define BR_RTC_CR_WPE(x)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_WPE))

/*! @brief Format value for bitfield RTC_CR_WPE. */
#define BF_RTC_CR_WPE(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_CR_WPE) & BM_RTC_CR_WPE)

/*! @brief Set the WPE field to a new value. */
#define BW_RTC_CR_WPE(x, v)  (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_WPE) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field SUP[2] (RW)
 *
 * Values:
 * - 0 - Non-supervisor mode write accesses are not supported and generate a bus
 *     error.
 * - 1 - Non-supervisor mode write accesses are supported.
 */
/*@{*/
#define BP_RTC_CR_SUP        (2U)          /*!< Bit position for RTC_CR_SUP. */
#define BM_RTC_CR_SUP        (0x00000004U) /*!< Bit mask for RTC_CR_SUP. */
#define BS_RTC_CR_SUP        (1U)          /*!< Bit field size in bits for RTC_CR_SUP. */

/*! @brief Read current value of the RTC_CR_SUP field. */
#define BR_RTC_CR_SUP(x)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SUP))

/*! @brief Format value for bitfield RTC_CR_SUP. */
#define BF_RTC_CR_SUP(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SUP) & BM_RTC_CR_SUP)

/*! @brief Set the SUP field to a new value. */
#define BW_RTC_CR_SUP(x, v)  (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SUP) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field UM[3] (RW)
 *
 * Allows SR[TCE] to be written even when the Status Register is locked. When
 * set, the SR[TCE] can always be written if the SR[TIF] or SR[TOF] are set or if
 * the SR[TCE] is clear.
 *
 * Values:
 * - 0 - Registers cannot be written when locked.
 * - 1 - Registers can be written when locked under limited conditions.
 */
/*@{*/
#define BP_RTC_CR_UM         (3U)          /*!< Bit position for RTC_CR_UM. */
#define BM_RTC_CR_UM         (0x00000008U) /*!< Bit mask for RTC_CR_UM. */
#define BS_RTC_CR_UM         (1U)          /*!< Bit field size in bits for RTC_CR_UM. */

/*! @brief Read current value of the RTC_CR_UM field. */
#define BR_RTC_CR_UM(x)      (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_UM))

/*! @brief Format value for bitfield RTC_CR_UM. */
#define BF_RTC_CR_UM(v)      ((uint32_t)((uint32_t)(v) << BP_RTC_CR_UM) & BM_RTC_CR_UM)

/*! @brief Set the UM field to a new value. */
#define BW_RTC_CR_UM(x, v)   (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_UM) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field WPS[4] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin asserts (active low, open drain) if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 * - 1 - Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin
 *     is turned on and the 32kHz clock is output to other peripherals.
 */
/*@{*/
#define BP_RTC_CR_WPS        (4U)          /*!< Bit position for RTC_CR_WPS. */
#define BM_RTC_CR_WPS        (0x00000010U) /*!< Bit mask for RTC_CR_WPS. */
#define BS_RTC_CR_WPS        (1U)          /*!< Bit field size in bits for RTC_CR_WPS. */

/*! @brief Read current value of the RTC_CR_WPS field. */
#define BR_RTC_CR_WPS(x)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_WPS))

/*! @brief Format value for bitfield RTC_CR_WPS. */
#define BF_RTC_CR_WPS(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_CR_WPS) & BM_RTC_CR_WPS)

/*! @brief Set the WPS field to a new value. */
#define BW_RTC_CR_WPS(x, v)  (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_WPS) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field OSCE[8] (RW)
 *
 * Values:
 * - 0 - 32.768 kHz oscillator is disabled.
 * - 1 - 32.768 kHz oscillator is enabled. After setting this bit, wait the
 *     oscillator startup time before enabling the time counter to allow the 32.768
 *     kHz clock time to stabilize.
 */
/*@{*/
#define BP_RTC_CR_OSCE       (8U)          /*!< Bit position for RTC_CR_OSCE. */
#define BM_RTC_CR_OSCE       (0x00000100U) /*!< Bit mask for RTC_CR_OSCE. */
#define BS_RTC_CR_OSCE       (1U)          /*!< Bit field size in bits for RTC_CR_OSCE. */

/*! @brief Read current value of the RTC_CR_OSCE field. */
#define BR_RTC_CR_OSCE(x)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_OSCE))

/*! @brief Format value for bitfield RTC_CR_OSCE. */
#define BF_RTC_CR_OSCE(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_CR_OSCE) & BM_RTC_CR_OSCE)

/*! @brief Set the OSCE field to a new value. */
#define BW_RTC_CR_OSCE(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_OSCE) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field CLKO[9] (RW)
 *
 * Values:
 * - 0 - The 32 kHz clock is output to other peripherals.
 * - 1 - The 32 kHz clock is not output to other peripherals.
 */
/*@{*/
#define BP_RTC_CR_CLKO       (9U)          /*!< Bit position for RTC_CR_CLKO. */
#define BM_RTC_CR_CLKO       (0x00000200U) /*!< Bit mask for RTC_CR_CLKO. */
#define BS_RTC_CR_CLKO       (1U)          /*!< Bit field size in bits for RTC_CR_CLKO. */

/*! @brief Read current value of the RTC_CR_CLKO field. */
#define BR_RTC_CR_CLKO(x)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_CLKO))

/*! @brief Format value for bitfield RTC_CR_CLKO. */
#define BF_RTC_CR_CLKO(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_CR_CLKO) & BM_RTC_CR_CLKO)

/*! @brief Set the CLKO field to a new value. */
#define BW_RTC_CR_CLKO(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_CLKO) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field SC16P[10] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
#define BP_RTC_CR_SC16P      (10U)         /*!< Bit position for RTC_CR_SC16P. */
#define BM_RTC_CR_SC16P      (0x00000400U) /*!< Bit mask for RTC_CR_SC16P. */
#define BS_RTC_CR_SC16P      (1U)          /*!< Bit field size in bits for RTC_CR_SC16P. */

/*! @brief Read current value of the RTC_CR_SC16P field. */
#define BR_RTC_CR_SC16P(x)   (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC16P))

/*! @brief Format value for bitfield RTC_CR_SC16P. */
#define BF_RTC_CR_SC16P(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SC16P) & BM_RTC_CR_SC16P)

/*! @brief Set the SC16P field to a new value. */
#define BW_RTC_CR_SC16P(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC16P) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field SC8P[11] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
#define BP_RTC_CR_SC8P       (11U)         /*!< Bit position for RTC_CR_SC8P. */
#define BM_RTC_CR_SC8P       (0x00000800U) /*!< Bit mask for RTC_CR_SC8P. */
#define BS_RTC_CR_SC8P       (1U)          /*!< Bit field size in bits for RTC_CR_SC8P. */

/*! @brief Read current value of the RTC_CR_SC8P field. */
#define BR_RTC_CR_SC8P(x)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC8P))

/*! @brief Format value for bitfield RTC_CR_SC8P. */
#define BF_RTC_CR_SC8P(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SC8P) & BM_RTC_CR_SC8P)

/*! @brief Set the SC8P field to a new value. */
#define BW_RTC_CR_SC8P(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC8P) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field SC4P[12] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
#define BP_RTC_CR_SC4P       (12U)         /*!< Bit position for RTC_CR_SC4P. */
#define BM_RTC_CR_SC4P       (0x00001000U) /*!< Bit mask for RTC_CR_SC4P. */
#define BS_RTC_CR_SC4P       (1U)          /*!< Bit field size in bits for RTC_CR_SC4P. */

/*! @brief Read current value of the RTC_CR_SC4P field. */
#define BR_RTC_CR_SC4P(x)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC4P))

/*! @brief Format value for bitfield RTC_CR_SC4P. */
#define BF_RTC_CR_SC4P(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SC4P) & BM_RTC_CR_SC4P)

/*! @brief Set the SC4P field to a new value. */
#define BW_RTC_CR_SC4P(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC4P) = (v))
/*@}*/

/*!
 * @name Register RTC_CR, field SC2P[13] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
#define BP_RTC_CR_SC2P       (13U)         /*!< Bit position for RTC_CR_SC2P. */
#define BM_RTC_CR_SC2P       (0x00002000U) /*!< Bit mask for RTC_CR_SC2P. */
#define BS_RTC_CR_SC2P       (1U)          /*!< Bit field size in bits for RTC_CR_SC2P. */

/*! @brief Read current value of the RTC_CR_SC2P field. */
#define BR_RTC_CR_SC2P(x)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC2P))

/*! @brief Format value for bitfield RTC_CR_SC2P. */
#define BF_RTC_CR_SC2P(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_CR_SC2P) & BM_RTC_CR_SC2P)

/*! @brief Set the SC2P field to a new value. */
#define BW_RTC_CR_SC2P(x, v) (BITBAND_ACCESS32(HW_RTC_CR_ADDR(x), BP_RTC_CR_SC2P) = (v))
/*@}*/

/*******************************************************************************
 * HW_RTC_SR - RTC Status Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_SR - RTC Status Register (RW)
 *
 * Reset value: 0x00000001U
 */
typedef union _hw_rtc_sr
{
    uint32_t U;
    struct _hw_rtc_sr_bitfields
    {
        uint32_t TIF : 1;              /*!< [0] Time Invalid Flag */
        uint32_t TOF : 1;              /*!< [1] Time Overflow Flag */
        uint32_t TAF : 1;              /*!< [2] Time Alarm Flag */
        uint32_t RESERVED0 : 1;        /*!< [3]  */
        uint32_t TCE : 1;              /*!< [4] Time Counter Enable */
        uint32_t RESERVED1 : 27;       /*!< [31:5]  */
    } B;
} hw_rtc_sr_t;

/*!
 * @name Constants and macros for entire RTC_SR register
 */
/*@{*/
#define HW_RTC_SR_ADDR(x)        ((x) + 0x14U)

#define HW_RTC_SR(x)             (*(__IO hw_rtc_sr_t *) HW_RTC_SR_ADDR(x))
#define HW_RTC_SR_RD(x)          (HW_RTC_SR(x).U)
#define HW_RTC_SR_WR(x, v)       (HW_RTC_SR(x).U = (v))
#define HW_RTC_SR_SET(x, v)      (HW_RTC_SR_WR(x, HW_RTC_SR_RD(x) |  (v)))
#define HW_RTC_SR_CLR(x, v)      (HW_RTC_SR_WR(x, HW_RTC_SR_RD(x) & ~(v)))
#define HW_RTC_SR_TOG(x, v)      (HW_RTC_SR_WR(x, HW_RTC_SR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_SR bitfields
 */

/*!
 * @name Register RTC_SR, field TIF[0] (RO)
 *
 * The time invalid flag is set on VBAT POR or software reset. The TSR and TPR
 * do not increment and read as zero when this bit is set. This bit is cleared by
 * writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time is valid.
 * - 1 - Time is invalid and time counter is read as zero.
 */
/*@{*/
#define BP_RTC_SR_TIF        (0U)          /*!< Bit position for RTC_SR_TIF. */
#define BM_RTC_SR_TIF        (0x00000001U) /*!< Bit mask for RTC_SR_TIF. */
#define BS_RTC_SR_TIF        (1U)          /*!< Bit field size in bits for RTC_SR_TIF. */

/*! @brief Read current value of the RTC_SR_TIF field. */
#define BR_RTC_SR_TIF(x)     (BITBAND_ACCESS32(HW_RTC_SR_ADDR(x), BP_RTC_SR_TIF))
/*@}*/

/*!
 * @name Register RTC_SR, field TOF[1] (RO)
 *
 * Time overflow flag is set when the time counter is enabled and overflows. The
 * TSR and TPR do not increment and read as zero when this bit is set. This bit
 * is cleared by writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time overflow has not occurred.
 * - 1 - Time overflow has occurred and time counter is read as zero.
 */
/*@{*/
#define BP_RTC_SR_TOF        (1U)          /*!< Bit position for RTC_SR_TOF. */
#define BM_RTC_SR_TOF        (0x00000002U) /*!< Bit mask for RTC_SR_TOF. */
#define BS_RTC_SR_TOF        (1U)          /*!< Bit field size in bits for RTC_SR_TOF. */

/*! @brief Read current value of the RTC_SR_TOF field. */
#define BR_RTC_SR_TOF(x)     (BITBAND_ACCESS32(HW_RTC_SR_ADDR(x), BP_RTC_SR_TOF))
/*@}*/

/*!
 * @name Register RTC_SR, field TAF[2] (RO)
 *
 * Time alarm flag is set when the TAR[TAR] equals the TSR[TSR] and the TSR[TSR]
 * increments. This bit is cleared by writing the TAR register.
 *
 * Values:
 * - 0 - Time alarm has not occurred.
 * - 1 - Time alarm has occurred.
 */
/*@{*/
#define BP_RTC_SR_TAF        (2U)          /*!< Bit position for RTC_SR_TAF. */
#define BM_RTC_SR_TAF        (0x00000004U) /*!< Bit mask for RTC_SR_TAF. */
#define BS_RTC_SR_TAF        (1U)          /*!< Bit field size in bits for RTC_SR_TAF. */

/*! @brief Read current value of the RTC_SR_TAF field. */
#define BR_RTC_SR_TAF(x)     (BITBAND_ACCESS32(HW_RTC_SR_ADDR(x), BP_RTC_SR_TAF))
/*@}*/

/*!
 * @name Register RTC_SR, field TCE[4] (RW)
 *
 * When time counter is disabled the TSR register and TPR register are
 * writeable, but do not increment. When time counter is enabled the TSR register and TPR
 * register are not writeable, but increment.
 *
 * Values:
 * - 0 - Time counter is disabled.
 * - 1 - Time counter is enabled.
 */
/*@{*/
#define BP_RTC_SR_TCE        (4U)          /*!< Bit position for RTC_SR_TCE. */
#define BM_RTC_SR_TCE        (0x00000010U) /*!< Bit mask for RTC_SR_TCE. */
#define BS_RTC_SR_TCE        (1U)          /*!< Bit field size in bits for RTC_SR_TCE. */

/*! @brief Read current value of the RTC_SR_TCE field. */
#define BR_RTC_SR_TCE(x)     (BITBAND_ACCESS32(HW_RTC_SR_ADDR(x), BP_RTC_SR_TCE))

/*! @brief Format value for bitfield RTC_SR_TCE. */
#define BF_RTC_SR_TCE(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_SR_TCE) & BM_RTC_SR_TCE)

/*! @brief Set the TCE field to a new value. */
#define BW_RTC_SR_TCE(x, v)  (BITBAND_ACCESS32(HW_RTC_SR_ADDR(x), BP_RTC_SR_TCE) = (v))
/*@}*/

/*******************************************************************************
 * HW_RTC_LR - RTC Lock Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_LR - RTC Lock Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_lr
{
    uint32_t U;
    struct _hw_rtc_lr_bitfields
    {
        uint32_t RESERVED0 : 3;        /*!< [2:0]  */
        uint32_t TCL : 1;              /*!< [3] Time Compensation Lock */
        uint32_t CRL : 1;              /*!< [4] Control Register Lock */
        uint32_t SRL : 1;              /*!< [5] Status Register Lock */
        uint32_t LRL : 1;              /*!< [6] Lock Register Lock */
        uint32_t RESERVED1 : 25;       /*!< [31:7]  */
    } B;
} hw_rtc_lr_t;

/*!
 * @name Constants and macros for entire RTC_LR register
 */
/*@{*/
#define HW_RTC_LR_ADDR(x)        ((x) + 0x18U)

#define HW_RTC_LR(x)             (*(__IO hw_rtc_lr_t *) HW_RTC_LR_ADDR(x))
#define HW_RTC_LR_RD(x)          (HW_RTC_LR(x).U)
#define HW_RTC_LR_WR(x, v)       (HW_RTC_LR(x).U = (v))
#define HW_RTC_LR_SET(x, v)      (HW_RTC_LR_WR(x, HW_RTC_LR_RD(x) |  (v)))
#define HW_RTC_LR_CLR(x, v)      (HW_RTC_LR_WR(x, HW_RTC_LR_RD(x) & ~(v)))
#define HW_RTC_LR_TOG(x, v)      (HW_RTC_LR_WR(x, HW_RTC_LR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_LR bitfields
 */

/*!
 * @name Register RTC_LR, field TCL[3] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Time Compensation Register is locked and writes are ignored.
 * - 1 - Time Compensation Register is not locked and writes complete as normal.
 */
/*@{*/
#define BP_RTC_LR_TCL        (3U)          /*!< Bit position for RTC_LR_TCL. */
#define BM_RTC_LR_TCL        (0x00000008U) /*!< Bit mask for RTC_LR_TCL. */
#define BS_RTC_LR_TCL        (1U)          /*!< Bit field size in bits for RTC_LR_TCL. */

/*! @brief Read current value of the RTC_LR_TCL field. */
#define BR_RTC_LR_TCL(x)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_TCL))

/*! @brief Format value for bitfield RTC_LR_TCL. */
#define BF_RTC_LR_TCL(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_LR_TCL) & BM_RTC_LR_TCL)

/*! @brief Set the TCL field to a new value. */
#define BW_RTC_LR_TCL(x, v)  (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_TCL) = (v))
/*@}*/

/*!
 * @name Register RTC_LR, field CRL[4] (RW)
 *
 * After being cleared, this bit can only be set by VBAT POR.
 *
 * Values:
 * - 0 - Control Register is locked and writes are ignored.
 * - 1 - Control Register is not locked and writes complete as normal.
 */
/*@{*/
#define BP_RTC_LR_CRL        (4U)          /*!< Bit position for RTC_LR_CRL. */
#define BM_RTC_LR_CRL        (0x00000010U) /*!< Bit mask for RTC_LR_CRL. */
#define BS_RTC_LR_CRL        (1U)          /*!< Bit field size in bits for RTC_LR_CRL. */

/*! @brief Read current value of the RTC_LR_CRL field. */
#define BR_RTC_LR_CRL(x)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_CRL))

/*! @brief Format value for bitfield RTC_LR_CRL. */
#define BF_RTC_LR_CRL(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_LR_CRL) & BM_RTC_LR_CRL)

/*! @brief Set the CRL field to a new value. */
#define BW_RTC_LR_CRL(x, v)  (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_CRL) = (v))
/*@}*/

/*!
 * @name Register RTC_LR, field SRL[5] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Status Register is locked and writes are ignored.
 * - 1 - Status Register is not locked and writes complete as normal.
 */
/*@{*/
#define BP_RTC_LR_SRL        (5U)          /*!< Bit position for RTC_LR_SRL. */
#define BM_RTC_LR_SRL        (0x00000020U) /*!< Bit mask for RTC_LR_SRL. */
#define BS_RTC_LR_SRL        (1U)          /*!< Bit field size in bits for RTC_LR_SRL. */

/*! @brief Read current value of the RTC_LR_SRL field. */
#define BR_RTC_LR_SRL(x)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_SRL))

/*! @brief Format value for bitfield RTC_LR_SRL. */
#define BF_RTC_LR_SRL(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_LR_SRL) & BM_RTC_LR_SRL)

/*! @brief Set the SRL field to a new value. */
#define BW_RTC_LR_SRL(x, v)  (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_SRL) = (v))
/*@}*/

/*!
 * @name Register RTC_LR, field LRL[6] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Lock Register is locked and writes are ignored.
 * - 1 - Lock Register is not locked and writes complete as normal.
 */
/*@{*/
#define BP_RTC_LR_LRL        (6U)          /*!< Bit position for RTC_LR_LRL. */
#define BM_RTC_LR_LRL        (0x00000040U) /*!< Bit mask for RTC_LR_LRL. */
#define BS_RTC_LR_LRL        (1U)          /*!< Bit field size in bits for RTC_LR_LRL. */

/*! @brief Read current value of the RTC_LR_LRL field. */
#define BR_RTC_LR_LRL(x)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_LRL))

/*! @brief Format value for bitfield RTC_LR_LRL. */
#define BF_RTC_LR_LRL(v)     ((uint32_t)((uint32_t)(v) << BP_RTC_LR_LRL) & BM_RTC_LR_LRL)

/*! @brief Set the LRL field to a new value. */
#define BW_RTC_LR_LRL(x, v)  (BITBAND_ACCESS32(HW_RTC_LR_ADDR(x), BP_RTC_LR_LRL) = (v))
/*@}*/

/*******************************************************************************
 * HW_RTC_IER - RTC Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_IER - RTC Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000007U
 */
typedef union _hw_rtc_ier
{
    uint32_t U;
    struct _hw_rtc_ier_bitfields
    {
        uint32_t TIIE : 1;             /*!< [0] Time Invalid Interrupt Enable */
        uint32_t TOIE : 1;             /*!< [1] Time Overflow Interrupt Enable */
        uint32_t TAIE : 1;             /*!< [2] Time Alarm Interrupt Enable */
        uint32_t RESERVED0 : 1;        /*!< [3]  */
        uint32_t TSIE : 1;             /*!< [4] Time Seconds Interrupt Enable */
        uint32_t RESERVED1 : 2;        /*!< [6:5]  */
        uint32_t WPON : 1;             /*!< [7] Wakeup Pin On */
        uint32_t RESERVED2 : 24;       /*!< [31:8]  */
    } B;
} hw_rtc_ier_t;

/*!
 * @name Constants and macros for entire RTC_IER register
 */
/*@{*/
#define HW_RTC_IER_ADDR(x)       ((x) + 0x1CU)

#define HW_RTC_IER(x)            (*(__IO hw_rtc_ier_t *) HW_RTC_IER_ADDR(x))
#define HW_RTC_IER_RD(x)         (HW_RTC_IER(x).U)
#define HW_RTC_IER_WR(x, v)      (HW_RTC_IER(x).U = (v))
#define HW_RTC_IER_SET(x, v)     (HW_RTC_IER_WR(x, HW_RTC_IER_RD(x) |  (v)))
#define HW_RTC_IER_CLR(x, v)     (HW_RTC_IER_WR(x, HW_RTC_IER_RD(x) & ~(v)))
#define HW_RTC_IER_TOG(x, v)     (HW_RTC_IER_WR(x, HW_RTC_IER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_IER bitfields
 */

/*!
 * @name Register RTC_IER, field TIIE[0] (RW)
 *
 * Values:
 * - 0 - Time invalid flag does not generate an interrupt.
 * - 1 - Time invalid flag does generate an interrupt.
 */
/*@{*/
#define BP_RTC_IER_TIIE      (0U)          /*!< Bit position for RTC_IER_TIIE. */
#define BM_RTC_IER_TIIE      (0x00000001U) /*!< Bit mask for RTC_IER_TIIE. */
#define BS_RTC_IER_TIIE      (1U)          /*!< Bit field size in bits for RTC_IER_TIIE. */

/*! @brief Read current value of the RTC_IER_TIIE field. */
#define BR_RTC_IER_TIIE(x)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TIIE))

/*! @brief Format value for bitfield RTC_IER_TIIE. */
#define BF_RTC_IER_TIIE(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_IER_TIIE) & BM_RTC_IER_TIIE)

/*! @brief Set the TIIE field to a new value. */
#define BW_RTC_IER_TIIE(x, v) (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TIIE) = (v))
/*@}*/

/*!
 * @name Register RTC_IER, field TOIE[1] (RW)
 *
 * Values:
 * - 0 - Time overflow flag does not generate an interrupt.
 * - 1 - Time overflow flag does generate an interrupt.
 */
/*@{*/
#define BP_RTC_IER_TOIE      (1U)          /*!< Bit position for RTC_IER_TOIE. */
#define BM_RTC_IER_TOIE      (0x00000002U) /*!< Bit mask for RTC_IER_TOIE. */
#define BS_RTC_IER_TOIE      (1U)          /*!< Bit field size in bits for RTC_IER_TOIE. */

/*! @brief Read current value of the RTC_IER_TOIE field. */
#define BR_RTC_IER_TOIE(x)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TOIE))

/*! @brief Format value for bitfield RTC_IER_TOIE. */
#define BF_RTC_IER_TOIE(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_IER_TOIE) & BM_RTC_IER_TOIE)

/*! @brief Set the TOIE field to a new value. */
#define BW_RTC_IER_TOIE(x, v) (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TOIE) = (v))
/*@}*/

/*!
 * @name Register RTC_IER, field TAIE[2] (RW)
 *
 * Values:
 * - 0 - Time alarm flag does not generate an interrupt.
 * - 1 - Time alarm flag does generate an interrupt.
 */
/*@{*/
#define BP_RTC_IER_TAIE      (2U)          /*!< Bit position for RTC_IER_TAIE. */
#define BM_RTC_IER_TAIE      (0x00000004U) /*!< Bit mask for RTC_IER_TAIE. */
#define BS_RTC_IER_TAIE      (1U)          /*!< Bit field size in bits for RTC_IER_TAIE. */

/*! @brief Read current value of the RTC_IER_TAIE field. */
#define BR_RTC_IER_TAIE(x)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TAIE))

/*! @brief Format value for bitfield RTC_IER_TAIE. */
#define BF_RTC_IER_TAIE(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_IER_TAIE) & BM_RTC_IER_TAIE)

/*! @brief Set the TAIE field to a new value. */
#define BW_RTC_IER_TAIE(x, v) (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TAIE) = (v))
/*@}*/

/*!
 * @name Register RTC_IER, field TSIE[4] (RW)
 *
 * The seconds interrupt is an edge-sensitive interrupt with a dedicated
 * interrupt vector. It is generated once a second and requires no software overhead
 * (there is no corresponding status flag to clear).
 *
 * Values:
 * - 0 - Seconds interrupt is disabled.
 * - 1 - Seconds interrupt is enabled.
 */
/*@{*/
#define BP_RTC_IER_TSIE      (4U)          /*!< Bit position for RTC_IER_TSIE. */
#define BM_RTC_IER_TSIE      (0x00000010U) /*!< Bit mask for RTC_IER_TSIE. */
#define BS_RTC_IER_TSIE      (1U)          /*!< Bit field size in bits for RTC_IER_TSIE. */

/*! @brief Read current value of the RTC_IER_TSIE field. */
#define BR_RTC_IER_TSIE(x)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TSIE))

/*! @brief Format value for bitfield RTC_IER_TSIE. */
#define BF_RTC_IER_TSIE(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_IER_TSIE) & BM_RTC_IER_TSIE)

/*! @brief Set the TSIE field to a new value. */
#define BW_RTC_IER_TSIE(x, v) (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_TSIE) = (v))
/*@}*/

/*!
 * @name Register RTC_IER, field WPON[7] (RW)
 *
 * The wakeup pin is optional and not available on all devices. Whenever the
 * wakeup pin is enabled and this bit is set, the wakeup pin will assert.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - If the wakeup pin is enabled, then the wakeup pin will assert.
 */
/*@{*/
#define BP_RTC_IER_WPON      (7U)          /*!< Bit position for RTC_IER_WPON. */
#define BM_RTC_IER_WPON      (0x00000080U) /*!< Bit mask for RTC_IER_WPON. */
#define BS_RTC_IER_WPON      (1U)          /*!< Bit field size in bits for RTC_IER_WPON. */

/*! @brief Read current value of the RTC_IER_WPON field. */
#define BR_RTC_IER_WPON(x)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_WPON))

/*! @brief Format value for bitfield RTC_IER_WPON. */
#define BF_RTC_IER_WPON(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_IER_WPON) & BM_RTC_IER_WPON)

/*! @brief Set the WPON field to a new value. */
#define BW_RTC_IER_WPON(x, v) (BITBAND_ACCESS32(HW_RTC_IER_ADDR(x), BP_RTC_IER_WPON) = (v))
/*@}*/

/*******************************************************************************
 * HW_RTC_WAR - RTC Write Access Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_WAR - RTC Write Access Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_war
{
    uint32_t U;
    struct _hw_rtc_war_bitfields
    {
        uint32_t TSRW : 1;             /*!< [0] Time Seconds Register Write */
        uint32_t TPRW : 1;             /*!< [1] Time Prescaler Register Write */
        uint32_t TARW : 1;             /*!< [2] Time Alarm Register Write */
        uint32_t TCRW : 1;             /*!< [3] Time Compensation Register Write */
        uint32_t CRW : 1;              /*!< [4] Control Register Write */
        uint32_t SRW : 1;              /*!< [5] Status Register Write */
        uint32_t LRW : 1;              /*!< [6] Lock Register Write */
        uint32_t IERW : 1;             /*!< [7] Interrupt Enable Register Write */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_rtc_war_t;

/*!
 * @name Constants and macros for entire RTC_WAR register
 */
/*@{*/
#define HW_RTC_WAR_ADDR(x)       ((x) + 0x800U)

#define HW_RTC_WAR(x)            (*(__IO hw_rtc_war_t *) HW_RTC_WAR_ADDR(x))
#define HW_RTC_WAR_RD(x)         (HW_RTC_WAR(x).U)
#define HW_RTC_WAR_WR(x, v)      (HW_RTC_WAR(x).U = (v))
#define HW_RTC_WAR_SET(x, v)     (HW_RTC_WAR_WR(x, HW_RTC_WAR_RD(x) |  (v)))
#define HW_RTC_WAR_CLR(x, v)     (HW_RTC_WAR_WR(x, HW_RTC_WAR_RD(x) & ~(v)))
#define HW_RTC_WAR_TOG(x, v)     (HW_RTC_WAR_WR(x, HW_RTC_WAR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_WAR bitfields
 */

/*!
 * @name Register RTC_WAR, field TSRW[0] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Seconds Register are ignored.
 * - 1 - Writes to the Time Seconds Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_TSRW      (0U)          /*!< Bit position for RTC_WAR_TSRW. */
#define BM_RTC_WAR_TSRW      (0x00000001U) /*!< Bit mask for RTC_WAR_TSRW. */
#define BS_RTC_WAR_TSRW      (1U)          /*!< Bit field size in bits for RTC_WAR_TSRW. */

/*! @brief Read current value of the RTC_WAR_TSRW field. */
#define BR_RTC_WAR_TSRW(x)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TSRW))

/*! @brief Format value for bitfield RTC_WAR_TSRW. */
#define BF_RTC_WAR_TSRW(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_TSRW) & BM_RTC_WAR_TSRW)

/*! @brief Set the TSRW field to a new value. */
#define BW_RTC_WAR_TSRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TSRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field TPRW[1] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Prescaler Register are ignored.
 * - 1 - Writes to the Time Prescaler Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_TPRW      (1U)          /*!< Bit position for RTC_WAR_TPRW. */
#define BM_RTC_WAR_TPRW      (0x00000002U) /*!< Bit mask for RTC_WAR_TPRW. */
#define BS_RTC_WAR_TPRW      (1U)          /*!< Bit field size in bits for RTC_WAR_TPRW. */

/*! @brief Read current value of the RTC_WAR_TPRW field. */
#define BR_RTC_WAR_TPRW(x)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TPRW))

/*! @brief Format value for bitfield RTC_WAR_TPRW. */
#define BF_RTC_WAR_TPRW(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_TPRW) & BM_RTC_WAR_TPRW)

/*! @brief Set the TPRW field to a new value. */
#define BW_RTC_WAR_TPRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TPRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field TARW[2] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Alarm Register are ignored.
 * - 1 - Writes to the Time Alarm Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_TARW      (2U)          /*!< Bit position for RTC_WAR_TARW. */
#define BM_RTC_WAR_TARW      (0x00000004U) /*!< Bit mask for RTC_WAR_TARW. */
#define BS_RTC_WAR_TARW      (1U)          /*!< Bit field size in bits for RTC_WAR_TARW. */

/*! @brief Read current value of the RTC_WAR_TARW field. */
#define BR_RTC_WAR_TARW(x)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TARW))

/*! @brief Format value for bitfield RTC_WAR_TARW. */
#define BF_RTC_WAR_TARW(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_TARW) & BM_RTC_WAR_TARW)

/*! @brief Set the TARW field to a new value. */
#define BW_RTC_WAR_TARW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TARW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field TCRW[3] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Compensation Register are ignored.
 * - 1 - Writes to the Time Compensation Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_TCRW      (3U)          /*!< Bit position for RTC_WAR_TCRW. */
#define BM_RTC_WAR_TCRW      (0x00000008U) /*!< Bit mask for RTC_WAR_TCRW. */
#define BS_RTC_WAR_TCRW      (1U)          /*!< Bit field size in bits for RTC_WAR_TCRW. */

/*! @brief Read current value of the RTC_WAR_TCRW field. */
#define BR_RTC_WAR_TCRW(x)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TCRW))

/*! @brief Format value for bitfield RTC_WAR_TCRW. */
#define BF_RTC_WAR_TCRW(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_TCRW) & BM_RTC_WAR_TCRW)

/*! @brief Set the TCRW field to a new value. */
#define BW_RTC_WAR_TCRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_TCRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field CRW[4] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Control Register are ignored.
 * - 1 - Writes to the Control Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_CRW       (4U)          /*!< Bit position for RTC_WAR_CRW. */
#define BM_RTC_WAR_CRW       (0x00000010U) /*!< Bit mask for RTC_WAR_CRW. */
#define BS_RTC_WAR_CRW       (1U)          /*!< Bit field size in bits for RTC_WAR_CRW. */

/*! @brief Read current value of the RTC_WAR_CRW field. */
#define BR_RTC_WAR_CRW(x)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_CRW))

/*! @brief Format value for bitfield RTC_WAR_CRW. */
#define BF_RTC_WAR_CRW(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_CRW) & BM_RTC_WAR_CRW)

/*! @brief Set the CRW field to a new value. */
#define BW_RTC_WAR_CRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_CRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field SRW[5] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Status Register are ignored.
 * - 1 - Writes to the Status Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_SRW       (5U)          /*!< Bit position for RTC_WAR_SRW. */
#define BM_RTC_WAR_SRW       (0x00000020U) /*!< Bit mask for RTC_WAR_SRW. */
#define BS_RTC_WAR_SRW       (1U)          /*!< Bit field size in bits for RTC_WAR_SRW. */

/*! @brief Read current value of the RTC_WAR_SRW field. */
#define BR_RTC_WAR_SRW(x)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_SRW))

/*! @brief Format value for bitfield RTC_WAR_SRW. */
#define BF_RTC_WAR_SRW(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_SRW) & BM_RTC_WAR_SRW)

/*! @brief Set the SRW field to a new value. */
#define BW_RTC_WAR_SRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_SRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field LRW[6] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Lock Register are ignored.
 * - 1 - Writes to the Lock Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_LRW       (6U)          /*!< Bit position for RTC_WAR_LRW. */
#define BM_RTC_WAR_LRW       (0x00000040U) /*!< Bit mask for RTC_WAR_LRW. */
#define BS_RTC_WAR_LRW       (1U)          /*!< Bit field size in bits for RTC_WAR_LRW. */

/*! @brief Read current value of the RTC_WAR_LRW field. */
#define BR_RTC_WAR_LRW(x)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_LRW))

/*! @brief Format value for bitfield RTC_WAR_LRW. */
#define BF_RTC_WAR_LRW(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_LRW) & BM_RTC_WAR_LRW)

/*! @brief Set the LRW field to a new value. */
#define BW_RTC_WAR_LRW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_LRW) = (v))
/*@}*/

/*!
 * @name Register RTC_WAR, field IERW[7] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Interupt Enable Register are ignored.
 * - 1 - Writes to the Interrupt Enable Register complete as normal.
 */
/*@{*/
#define BP_RTC_WAR_IERW      (7U)          /*!< Bit position for RTC_WAR_IERW. */
#define BM_RTC_WAR_IERW      (0x00000080U) /*!< Bit mask for RTC_WAR_IERW. */
#define BS_RTC_WAR_IERW      (1U)          /*!< Bit field size in bits for RTC_WAR_IERW. */

/*! @brief Read current value of the RTC_WAR_IERW field. */
#define BR_RTC_WAR_IERW(x)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_IERW))

/*! @brief Format value for bitfield RTC_WAR_IERW. */
#define BF_RTC_WAR_IERW(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_WAR_IERW) & BM_RTC_WAR_IERW)

/*! @brief Set the IERW field to a new value. */
#define BW_RTC_WAR_IERW(x, v) (BITBAND_ACCESS32(HW_RTC_WAR_ADDR(x), BP_RTC_WAR_IERW) = (v))
/*@}*/

/*******************************************************************************
 * HW_RTC_RAR - RTC Read Access Register
 ******************************************************************************/

/*!
 * @brief HW_RTC_RAR - RTC Read Access Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_rar
{
    uint32_t U;
    struct _hw_rtc_rar_bitfields
    {
        uint32_t TSRR : 1;             /*!< [0] Time Seconds Register Read */
        uint32_t TPRR : 1;             /*!< [1] Time Prescaler Register Read */
        uint32_t TARR : 1;             /*!< [2] Time Alarm Register Read */
        uint32_t TCRR : 1;             /*!< [3] Time Compensation Register Read */
        uint32_t CRR : 1;              /*!< [4] Control Register Read */
        uint32_t SRR : 1;              /*!< [5] Status Register Read */
        uint32_t LRR : 1;              /*!< [6] Lock Register Read */
        uint32_t IERR : 1;             /*!< [7] Interrupt Enable Register Read */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_rtc_rar_t;

/*!
 * @name Constants and macros for entire RTC_RAR register
 */
/*@{*/
#define HW_RTC_RAR_ADDR(x)       ((x) + 0x804U)

#define HW_RTC_RAR(x)            (*(__IO hw_rtc_rar_t *) HW_RTC_RAR_ADDR(x))
#define HW_RTC_RAR_RD(x)         (HW_RTC_RAR(x).U)
#define HW_RTC_RAR_WR(x, v)      (HW_RTC_RAR(x).U = (v))
#define HW_RTC_RAR_SET(x, v)     (HW_RTC_RAR_WR(x, HW_RTC_RAR_RD(x) |  (v)))
#define HW_RTC_RAR_CLR(x, v)     (HW_RTC_RAR_WR(x, HW_RTC_RAR_RD(x) & ~(v)))
#define HW_RTC_RAR_TOG(x, v)     (HW_RTC_RAR_WR(x, HW_RTC_RAR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RTC_RAR bitfields
 */

/*!
 * @name Register RTC_RAR, field TSRR[0] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Seconds Register are ignored.
 * - 1 - Reads to the Time Seconds Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_TSRR      (0U)          /*!< Bit position for RTC_RAR_TSRR. */
#define BM_RTC_RAR_TSRR      (0x00000001U) /*!< Bit mask for RTC_RAR_TSRR. */
#define BS_RTC_RAR_TSRR      (1U)          /*!< Bit field size in bits for RTC_RAR_TSRR. */

/*! @brief Read current value of the RTC_RAR_TSRR field. */
#define BR_RTC_RAR_TSRR(x)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TSRR))

/*! @brief Format value for bitfield RTC_RAR_TSRR. */
#define BF_RTC_RAR_TSRR(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_TSRR) & BM_RTC_RAR_TSRR)

/*! @brief Set the TSRR field to a new value. */
#define BW_RTC_RAR_TSRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TSRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field TPRR[1] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Pprescaler Register are ignored.
 * - 1 - Reads to the Time Prescaler Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_TPRR      (1U)          /*!< Bit position for RTC_RAR_TPRR. */
#define BM_RTC_RAR_TPRR      (0x00000002U) /*!< Bit mask for RTC_RAR_TPRR. */
#define BS_RTC_RAR_TPRR      (1U)          /*!< Bit field size in bits for RTC_RAR_TPRR. */

/*! @brief Read current value of the RTC_RAR_TPRR field. */
#define BR_RTC_RAR_TPRR(x)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TPRR))

/*! @brief Format value for bitfield RTC_RAR_TPRR. */
#define BF_RTC_RAR_TPRR(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_TPRR) & BM_RTC_RAR_TPRR)

/*! @brief Set the TPRR field to a new value. */
#define BW_RTC_RAR_TPRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TPRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field TARR[2] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Alarm Register are ignored.
 * - 1 - Reads to the Time Alarm Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_TARR      (2U)          /*!< Bit position for RTC_RAR_TARR. */
#define BM_RTC_RAR_TARR      (0x00000004U) /*!< Bit mask for RTC_RAR_TARR. */
#define BS_RTC_RAR_TARR      (1U)          /*!< Bit field size in bits for RTC_RAR_TARR. */

/*! @brief Read current value of the RTC_RAR_TARR field. */
#define BR_RTC_RAR_TARR(x)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TARR))

/*! @brief Format value for bitfield RTC_RAR_TARR. */
#define BF_RTC_RAR_TARR(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_TARR) & BM_RTC_RAR_TARR)

/*! @brief Set the TARR field to a new value. */
#define BW_RTC_RAR_TARR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TARR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field TCRR[3] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Compensation Register are ignored.
 * - 1 - Reads to the Time Compensation Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_TCRR      (3U)          /*!< Bit position for RTC_RAR_TCRR. */
#define BM_RTC_RAR_TCRR      (0x00000008U) /*!< Bit mask for RTC_RAR_TCRR. */
#define BS_RTC_RAR_TCRR      (1U)          /*!< Bit field size in bits for RTC_RAR_TCRR. */

/*! @brief Read current value of the RTC_RAR_TCRR field. */
#define BR_RTC_RAR_TCRR(x)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TCRR))

/*! @brief Format value for bitfield RTC_RAR_TCRR. */
#define BF_RTC_RAR_TCRR(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_TCRR) & BM_RTC_RAR_TCRR)

/*! @brief Set the TCRR field to a new value. */
#define BW_RTC_RAR_TCRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_TCRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field CRR[4] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Control Register are ignored.
 * - 1 - Reads to the Control Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_CRR       (4U)          /*!< Bit position for RTC_RAR_CRR. */
#define BM_RTC_RAR_CRR       (0x00000010U) /*!< Bit mask for RTC_RAR_CRR. */
#define BS_RTC_RAR_CRR       (1U)          /*!< Bit field size in bits for RTC_RAR_CRR. */

/*! @brief Read current value of the RTC_RAR_CRR field. */
#define BR_RTC_RAR_CRR(x)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_CRR))

/*! @brief Format value for bitfield RTC_RAR_CRR. */
#define BF_RTC_RAR_CRR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_CRR) & BM_RTC_RAR_CRR)

/*! @brief Set the CRR field to a new value. */
#define BW_RTC_RAR_CRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_CRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field SRR[5] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Status Register are ignored.
 * - 1 - Reads to the Status Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_SRR       (5U)          /*!< Bit position for RTC_RAR_SRR. */
#define BM_RTC_RAR_SRR       (0x00000020U) /*!< Bit mask for RTC_RAR_SRR. */
#define BS_RTC_RAR_SRR       (1U)          /*!< Bit field size in bits for RTC_RAR_SRR. */

/*! @brief Read current value of the RTC_RAR_SRR field. */
#define BR_RTC_RAR_SRR(x)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_SRR))

/*! @brief Format value for bitfield RTC_RAR_SRR. */
#define BF_RTC_RAR_SRR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_SRR) & BM_RTC_RAR_SRR)

/*! @brief Set the SRR field to a new value. */
#define BW_RTC_RAR_SRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_SRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field LRR[6] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Lock Register are ignored.
 * - 1 - Reads to the Lock Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_LRR       (6U)          /*!< Bit position for RTC_RAR_LRR. */
#define BM_RTC_RAR_LRR       (0x00000040U) /*!< Bit mask for RTC_RAR_LRR. */
#define BS_RTC_RAR_LRR       (1U)          /*!< Bit field size in bits for RTC_RAR_LRR. */

/*! @brief Read current value of the RTC_RAR_LRR field. */
#define BR_RTC_RAR_LRR(x)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_LRR))

/*! @brief Format value for bitfield RTC_RAR_LRR. */
#define BF_RTC_RAR_LRR(v)    ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_LRR) & BM_RTC_RAR_LRR)

/*! @brief Set the LRR field to a new value. */
#define BW_RTC_RAR_LRR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_LRR) = (v))
/*@}*/

/*!
 * @name Register RTC_RAR, field IERR[7] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Interrupt Enable Register are ignored.
 * - 1 - Reads to the Interrupt Enable Register complete as normal.
 */
/*@{*/
#define BP_RTC_RAR_IERR      (7U)          /*!< Bit position for RTC_RAR_IERR. */
#define BM_RTC_RAR_IERR      (0x00000080U) /*!< Bit mask for RTC_RAR_IERR. */
#define BS_RTC_RAR_IERR      (1U)          /*!< Bit field size in bits for RTC_RAR_IERR. */

/*! @brief Read current value of the RTC_RAR_IERR field. */
#define BR_RTC_RAR_IERR(x)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_IERR))

/*! @brief Format value for bitfield RTC_RAR_IERR. */
#define BF_RTC_RAR_IERR(v)   ((uint32_t)((uint32_t)(v) << BP_RTC_RAR_IERR) & BM_RTC_RAR_IERR)

/*! @brief Set the IERR field to a new value. */
#define BW_RTC_RAR_IERR(x, v) (BITBAND_ACCESS32(HW_RTC_RAR_ADDR(x), BP_RTC_RAR_IERR) = (v))
/*@}*/

/*******************************************************************************
 * hw_rtc_t - module struct
 ******************************************************************************/
/*!
 * @brief All RTC module registers.
 */
#pragma pack(1)
typedef struct _hw_rtc
{
    __IO hw_rtc_tsr_t TSR;                 /*!< [0x0] RTC Time Seconds Register */
    __IO hw_rtc_tpr_t TPR;                 /*!< [0x4] RTC Time Prescaler Register */
    __IO hw_rtc_tar_t TAR;                 /*!< [0x8] RTC Time Alarm Register */
    __IO hw_rtc_tcr_t TCR;                 /*!< [0xC] RTC Time Compensation Register */
    __IO hw_rtc_cr_t CR;                   /*!< [0x10] RTC Control Register */
    __IO hw_rtc_sr_t SR;                   /*!< [0x14] RTC Status Register */
    __IO hw_rtc_lr_t LR;                   /*!< [0x18] RTC Lock Register */
    __IO hw_rtc_ier_t IER;                 /*!< [0x1C] RTC Interrupt Enable Register */
    uint8_t _reserved0[2016];
    __IO hw_rtc_war_t WAR;                 /*!< [0x800] RTC Write Access Register */
    __IO hw_rtc_rar_t RAR;                 /*!< [0x804] RTC Read Access Register */
} hw_rtc_t;
#pragma pack()

/*! @brief Macro to access all RTC registers. */
/*! @param x RTC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_RTC(RTC_BASE)</code>. */
#define HW_RTC(x)      (*(hw_rtc_t *)(x))

#endif /* __HW_RTC_REGISTERS_H__ */
/* EOF */
