#include "mbed.h"

//SPI Slave
SPISlave device(dp2, dp1, dp6, dp25); // mosi, miso, sclk, ssel
Serial pc(USBTX, USBRX); 
 
 int main() {
     pc.baud(9600);
     //pc.format(8, SerialBase::None, 1);
     device.frequency(1000000);
     device.format(8, 0);
     device.reply(0x00);
     
     int i = 0; 
     
     while(1) {
         
         uint8_t instruction = 0xAB; 
         
         pc.printf("waiting for instruction");
         device.reply(0xFF);

         while(!device.receive()) {
             if(i++ % 10000 == 0) {
                 printf(".");
             }
         }
         pc.printf("\r\n");
         instruction = device.read();   // Read byte from master
         
         if(instruction == 0xFF) {
            continue;
         } 
         
         uint8_t reply = instruction + 0x10; 
         device.reply(reply);
                 
         pc.printf("waiting for reply signal");
         while(!device.receive()) {
             if(i++ % 10000 == 0) {
                 printf(".");
             }
         }
         pc.printf("\r\n");
    
         uint8_t ignore = device.read();
         
         pc.printf("instruction: 0x%X; reply: 0x%X; dummy_instruction: 0x%X\r\n", instruction, reply, ignore); 
         
     }   
      
 }
