#include "mbed.h"

//SPI Slave
//SPISlave device(D11, D12, D13, D10); // mosi, miso, sclk, ssel //nope
//SPISlave device(D11, D12, D13, PTA14); // mosi, miso, sclk, ssel //nope

//frdm
SPISlave device(D11, D12, D13, D10); // mosi, miso, sclk, ssel //nope

//archble
//SPISlave device(p25, p28, p29, p24); // mosi, miso, sclk, ssel //nope

//SPISlave device(PTA16, PTA17, PTA15, PTB9); // mosi, miso, sclk, ssel
//SPISlave device(PTD6, PTD7, PTD5, PTD4); // mosi, miso, sclk, ssel
//SPISlave device(PTA16, PTA17, PTA15, D10);
Serial pc(USBTX, USBRX); 
 
int main() {
     pc.baud(9600);
     
     //pc.format(8, SerialBase::None, 1);
     device.frequency(1000000);
     //device.format(8, 0);
     
     //frm requires mode 1
     device.format(8, 1);
     
     pc.printf("common. work.\r\n");
     
     int i = 0; 
     
     while(1) {
         
         device.reply(0xFF);
         //pc.printf("press any key\r\n");
         //pc.getc();
         
         //ir = 1; 
         //ir = 0;    

         pc.printf("waiting for instructions\r\n");
         
         while(!device.receive()) {
             if(i++ % 10000 == 0) {
                 printf(".");
             }
         }
         
         pc.printf("\r\n");
         uint8_t instruction = device.read();   // Read byte from master
         
         if(instruction == 0xFF) {
            pc.printf("instruction was FF...\r\n");
            continue;
         }         
         pc.printf("instruction: 0x%X; dummy_reply: 0x%X; ", instruction, 0xFF); 

         uint8_t reply = instruction + 0x10;
         //uint8_t reply = instruction << 1; 
         device.reply(reply);
         
         pc.printf("waiting for reply signal");
         while(!device.receive()) {
             if(i++ % 10000 == 0) {
                 printf(".");
             }
         }
         pc.printf("\r\n");
    
         uint8_t ignore = device.read();
         pc.printf("dummy_instruction: 0x%X; reply: 0x%X\r\n", ignore, reply); 

         //pc.printf("instruction: 0x%X; reply: 0x%X; dummy_instruction: 0x%X\r\n", instruction, reply, ignore); 
         
     }   
      
 }
