#include "mbed.h"

//SPI Master

Serial pc(USBTX, USBRX);
DigitalOut led(LED1);

//arch ble
//SPI spi(p25, p28, p29); // mosi, miso, sclk
//DigitalOut cs(p24);

//frdm - spi0
//SPI spi(PTD6, PTD7, PTD5); // mosi, miso, sclk
//DigitalOut cs(PTA14);
//ssel seems to work, data = ff :(

//frdm - spi1
SPI spi(D11, D12, D13); // mosi, miso, sclk
DigitalOut cs(D10);


int main() {

    spi.format(8,1); 
    spi.frequency(1000000);
    int i = 0;
    
    while(1) {
        
        cs = 0;
        spi.write(0xFE);
        cs = 1;
        
        wait_ms(1);
        
        cs = 0;
        uint8_t response = spi.write(0xFF);
        cs = 1;
        
        if(response != 0x0) {
            printf("received keystroke %x\r\n", response);
        } 
        
        wait_ms(1);
        
        cs = 0;
        spi.write(response);
        cs = 1;
          
        wait_ms(1);          
    }


}