#include "mbed.h"

//SPI Master

Serial pc(USBTX, USBRX);
DigitalOut led(LED1);

//arch ble
//SPI spi(p25, p28, p29); // mosi, miso, sclk
//DigitalOut cs(p24);

//frdm - spi0
//SPI spi(PTD6, PTD7, PTD5); // mosi, miso, sclk
//DigitalOut cs(PTA14);
//ssel seems to work, data = ff :(

//frdm - spi1
//SPI spi(D11, D12, D13); // mosi, miso, sclk
//DigitalOut cs(D10);

SPI spi(PTA16, PTA17, PTA15); // mosi, miso, sclk
DigitalOut cs(PTA14);


int main() {
    cs = 1;
    spi.format(8,3); //not usefull results
    spi.frequency(1000000);
    //spi.frequency(4000000);    
    uint8_t i;
    int j = 0;
    uint8_t fail; 
    uint8_t success; 

    
    while(1) {
        fail = 0; 
        success = 0;
         
        for (i = 0; i < 10; i++) {
     
            cs = 0;
            uint8_t garbage = spi.write(i);
            cs = 1;
            
            wait_ms(10);
            
            cs = 0;
            uint8_t response = spi.write(0xFA);
            cs = 1;
            
            printf("send: %x received: %x garb: %x \r\n", i, response, garbage);
                                       
            if(response == i + 0x10) {
                success++;
            } else {
                fail++; 
            }
            
            wait_ms(2000);

            
        }
        
        pc.printf("%d: fails: %d, success: %d\r\n",j++ , fail, success);
        wait(.5);

    }


}