#include "mbed.h"
#include "USBSerial.h"

//SPI Master

SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
USBSerial serial; 
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
DigitalOut cs(P0_2);
 
int main() {

    spi.format(8,0);
    spi.frequency(1000000);    
    uint8_t i = 0; 
     
    while(1) {
        
        cs = 0;
        wait_ms(1);
        uint8_t dummy_response = spi.write(i);
        wait_ms(1);
        cs = 1;
        wait_ms(1);
        cs = 0;
        uint8_t response = spi.write(0xFF);
        wait_ms(1);
        cs = 1;
        wait_ms(1);
                        
        serial.printf("instruction: 0x%X; response: = 0x%X; dummy_response = 0x%X\r\n", i, response, dummy_response);
        
        wait(2);
        led = 1;
        wait(.5);
        led = 0;
        i++;
    }

}