#include "mbed.h"

//Pull everything up
DigitalOut pull1(PTE2);
DigitalOut pull2(PTA2);
//DigitalOut pull4(PTA12);
//DigitalOut pull5(PTA4);
DigitalOut pull6(PTA5);
//DigitalOut pull7(PTC8);

DigitalOut pull9(PTA13);
DigitalOut pull10(PTD5);
DigitalOut pull11(PTD0);
DigitalOut pull12(PTD2);
DigitalOut pull13(PTD3);
DigitalOut pull14(PTD1);
DigitalOut pull15(PTE0);
DigitalOut pull16(PTE1);

//DigitalOut pull17(PTC7);
//DigitalOut pull18(PTC0);
//DigitalOut pull19(PTC3);
DigitalOut pull20(PTC4);


DigitalOut pull27(PTE31);
DigitalOut pull28(PTD6);
DigitalOut pull29(PTD7);

//DigitalOut pull30(PTE30);

//DigitalOut pull38(PTE3);
//DigitalOut pull39(PTE2);
//DigitalOut pull50(PTB11);
//DigitalOut pull51(PTB10);
//DigitalOut pull52(PTB9);
//DigitalOut pull53(PTB8);

//DigitalOut pull34(PTE21);
//DigitalOut pull35(PTE20);
//DigitalOut pull47(PTB1);
//DigitalOut pull48(PTB0);
DigitalOut pull100(PTA20);

//motor driver outputs
DigitalOut IN4(PTC5);
DigitalOut IN3(PTC6);
DigitalOut IN2(PTC10);
DigitalOut IN1(PTC11);
PwmOut ENA(PTC9);
PwmOut ENB(PTD4);

DigitalOut indicator(LED_BLUE);

//constant 3.3 volts for sensors
DigitalOut constant1(PTE5);
DigitalOut constant2(PTE4);
DigitalOut constant3(PTE3);
DigitalOut constant4(PTC0);
DigitalOut constant5(PTC7);
DigitalOut constant6 (PTC3);

//line following inputs
AnalogIn leftmost(PTB0);
AnalogIn left(PTC2);
AnalogIn middle(PTB3);
AnalogIn right(PTB2);
AnalogIn rightmost(PTB1);

DigitalIn back(PTB10);
DigitalIn midbar(PTB11);
DigitalIn front(PTE2);

//debugging led outputs
DigitalOut ledleftmost(PTE20);
DigitalOut ledright(PTE23);
DigitalOut ledmiddle(PTE22);
DigitalOut ledleft(PTE29);
DigitalOut ledrightmost(PTE21);

DigitalOut ledback(PTC4);
DigitalOut ledmidbar(PTB8);
DigitalOut ledfront(PTB9);

//ball firing
PwmOut motors(PTA12);
DigitalOut solenoid(PTA2);

//Ball dispensing
DigitalOut dispenser(PTA4);

//Ball Counter
DigitalOut constant7(PTC16);
DigitalOut bcd1(PTC17);
DigitalOut bcd0(PTE31);
DigitalOut bcd3(PTA17);
DigitalOut bcd2(PTA16);
InterruptIn ball_trigger(PTD7);
DigitalOut constant8(PTD6);

//Serial bluetooth(PTD3, PTD2); //tx,rx
PwmOut speaker(PTA5);


//Old
/*Ticker sine_interrupt;
AnalogOut Aout(PTE30);
double interrupt_f = .00001525878;                  //  (1/2048*32)
static int sine_wave_steps = 32;                    // number of steps in sine wave
int sine_counter = 0;
static float sine_val[] = {.5,.5976,.6914,.7773,.8535,.9160,.9619,.9902,1,.9902,.9619,.9160,.8535,.7773,.6914,.5976,.5,.4023,.3085,.2226,.1464,.0839,.0380,.0097,0,.0097,.0380,.0839,.1464,.2226,.3085,.4023};


void create_sine() {                                //subroutine for interrupt, creates sine wave
    sine_counter = sine_counter + 1;                //run through sine array
    if (sine_counter >= sine_wave_steps){
           sine_counter = 0;                            //repeat sine wave
    }
    Aout = sine_val[sine_counter];                  //output decimal 0-1 on DAC
}*/
int counter = 0;
int bar=0;
int i=0;
static int ballcount=0;

float k = 0;

bool go_slower=true;
bool stop=false;

void sound()
{
    //speaker.period(1.0/500.0); // 500hz period
    //speaker =0.5; //50% duty cycle - max volume

    for (k=400; k<470; k=k+8) {
        speaker.period(1.0/float(k));
        speaker=0.5;
        wait(.1);
    }

    speaker=0;
}


void debugger()
{
    //speaker.period(1.0/500.0); // 500hz period
    //speaker =0.5; //50% duty cycle - max volume

    for (k=400; k<435; k=k+7) {
        speaker.period(1.0/float(k));
        speaker=0.5;
        wait(.1);
    }

    speaker=0;
}



void display()
{

    if (ballcount == 0) {
        bcd0 = 0;
        bcd1 = 0;
        bcd2 = 0;
        bcd3 = 0;
    }
    if (ballcount == 1) {
        bcd0 = 1;
        bcd1 = 0;
        bcd2 = 0;
        bcd3 = 0;
    }
    if (ballcount == 2) {
        bcd0 = 0;
        bcd1 = 1;
        bcd2 = 0;
        bcd3 = 0;
    }
    if (ballcount == 3) {
        bcd0 = 1;
        bcd1 = 1;
        bcd2 = 0;
        bcd3 = 0;
    }
    if (ballcount == 4) {
        bcd0 = 0;
        bcd1 = 0;
        bcd2 = 1;
        bcd3 = 0;
    }
    if (ballcount == 5) {
        bcd0 = 1;
        bcd1 = 0;
        bcd2 = 1;
        bcd3 = 0;
    }
     if (ballcount > 5) {
        ballcount = 0;
    }
}

int loops=0;

void generatepwm(){
    loops=0;
    while(loops<2000){
        dispenser=1;
        wait_us(244);    
        dispenser=0; 
        wait_us(244); 
        loops++;
    }  
}

bool balldrop=false;

void count()
{
    if(balldrop==true){
        wait_ms(0.55); //this time has to be optimised to stop false positives
        if(ball_trigger==0) {
            ballcount++;
            indicator = 0;
            wait (0.25);
            indicator = 1;
            display();
        }      
    } 
}

int balls=0;

int barcode()
{
    
    /*if(front==1 or midbar==1 or back==1){
        //ENA=0.29;
        //ENB=0.29;
        }
        */
    if(front==1) {
        ledfront=1;
        //ENA=0.25;
        //ENB=0.25;
    } else {
        ledfront=0;
    }

    if(midbar==1) {
        ledmidbar=1;
        //ENA=0.25;
        //ENB=0.25;
    } else {
        ledmidbar=0;
    }

    if(back==1) {
        ledback=1;
        //ENA=0.25;
        //ENB=0.25;
    } else {
        ledback=0;
    }

    if(midbar==1 and back==1 and front==0){ //or (midbar==1 and front==1)) {
        //shoot balls
        ballcount=5;
        display();
        ENA=0;
        ENB=0;
        motors=0.09;
        stop=false;
        if (ballcount>0){
        while(ballcount>0){
            ballcount--;                   
            sound();
            wait_ms(550);
            solenoid=1;
            display();
            wait_ms(45);
            solenoid=0;
            wait(1);
            stop=true;
        }
        }
        go_slower=false;   
        motors=0;
        ENA=0.35;
        ENB=0.35;
        if(stop==true){
            wait(2);   
        }       
        return bar==1;
    } else if(front==1 and midbar==0 and back==1) { //test barcode   
        balldrop=true;     
        ballcount=0;
        display();
        ENA=0;
        ENB=0;
        while(ballcount<5){
            generatepwm();
            dispenser=0;
            wait(1);           
        }        
        ENA=0.35;
        ENB=0.35;
        wait(2);
        go_slower=true;
        return bar==1;
    }
    
    

    //sine_interrupt.detach();
    wait(0.1);
    return bar ==0;
}
int main()
{


    pull100=0;
    pull1=0;
    pull2=0;
    //pull3.mode(PullUp);
    //pull4=0;
    //pull5=0;
    pull6=0;
    //pull7=0;
    //pull8.mode(PullUp);
    pull9=0;
    pull10=0;
    pull11=0;
    pull12=0;
    pull13=0;
    pull14=0;
    pull15=0;
    pull16=0;
    //pull17=0;
    //pull18=0;
    //pull19=0;
    pull20=0;
    //pull21=0;
    //pull22=0;
    //pull23=0;
    //pull24=0;
    //pull25=0;
    //pull26=0;
    pull27=0;
    pull28=0;
    pull29=0;
    //pull30=0;
    //pull34=0;
    //pull35=0;
    //pull38=0;
    //pull39=0;
    //pull47=0;
    //pull48=0;
    //pull49=0;
    //pull50=0;
    //pull51=0;
    //pull52=0;
    //pull53=0;




    motors.period(3.0);
    motors.write(0);
    solenoid=0;



    constant1=1;
    constant2=1;
    constant3=1;
    constant4=1;
    constant5=1;
    constant6=1;
    

    indicator=1;
    wait(0.3);
    indicator=0;
    wait(0.3);
    indicator=1;
    wait(0.3);
    indicator=0;// because its a pile of shite

    dispenser=0;

    ENA.period(0.001);
    ENB.period(0.001);

    IN1=0;
    IN2=1;
    IN3=0;
    IN4=1;
    //set inital pwm values for motor driver outputs
    ENA=0;
    ENB=0;
    //You´ll never be the real slim shady
    //int counter=0;

    bcd0 = 0;
    bcd1 = 0;
    bcd2 = 0;
    bcd3 = 0;
    constant7 = 1;
    constant8=1;
    ballcount=0;

    ball_trigger.fall(&count);
    //sine_interrupt.attach(&create_sine , interrupt_f);

    while(1) {

        //sine_interrupt.attach(&create_sine , interrupt_f);
        //sine_interrupt.detach();

        bar = 0;
        balldrop=false;
        //counter=counter+1;
        //zonecounter=zonecounter+1;

        if(middle<0.4 & left<0.4 & right<0.4 & leftmost<0.4 & rightmost<0.4) {
            //skip the loop
            ledmiddle=0;
            ledleft=0;
            ledright=0;
            ledleftmost=0;
            ledrightmost=0;

            
        } else {


            if(middle>0.4) {
                ledmiddle=1;
                ENA=0.46;
                ENB=0.45;
            } else {
                ledmiddle=0;
                ENA=0.41;
                ENB=0.4;
            }
            
            if(go_slower==true){
                ENA=0.39;
                ENB=0.38;       
            }

            if(left>0.4) {
                ledleft=1;
                ENA=0.3;
            } else {
                ledleft=0;
            }

            if(right>0.4) {
                ledright=1;
                ENB=0.28;
            } else {
                ledright=0;
            }



            if(leftmost>0.4) {
                ledleftmost=1;
                ENA=0;
            } else {
                ledleftmost=0;
            }



            if(rightmost>0.4) {
                ledrightmost=1;
                ENB=0;
            } else {
                ledrightmost=0;
            }



            if((left>0.4 or leftmost>0.4)and(right>0.4 or rightmost>0.4)) {
                ENB=0.38;
                ENA=0;
                wait(2);             
            }



            if(bar == 0) { 
                barcode();
            }




            wait(0.01);


        }
    }
}

