#include "mbed.h"

//Pull everything down
DigitalOut pull1(PTE2);
DigitalOut pull2(PTA2);
DigitalOut pull6(PTA5);
DigitalOut pull9(PTA13);
DigitalOut pull10(PTD5);
DigitalOut pull11(PTD0);
DigitalOut pull12(PTD2);
DigitalOut pull13(PTD3);
DigitalOut pull14(PTD1);
DigitalOut pull15(PTE0);
DigitalOut pull16(PTE1);
DigitalOut pull19(PTC3);
DigitalOut pull21(PTC12);
DigitalOut pull22(PTC13);
DigitalOut pull23(PTC16);
DigitalOut pull24(PTC17);
DigitalOut pull25(PTA16);
DigitalOut pull26(PTA17);
DigitalOut pull27(PTE31);
DigitalOut pull28(PTD6);
DigitalOut pull29(PTD7);

//motor driver outputs
DigitalOut IN4(PTC5);
DigitalOut IN3(PTC6);
DigitalOut IN2(PTC10);
DigitalOut IN1(PTC11);
PwmOut ENA(PTC9);
PwmOut ENB(PTD4);

DigitalOut indicator(LED_GREEN);

//constant 3.3 volts for sensors
DigitalOut constant1(PTE5);
DigitalOut constant2(PTE4);
DigitalOut constant3(PTE3);
DigitalOut constant4(PTC0);
DigitalOut constant5(PTC7);

//line following inputs
AnalogIn leftmost(PTB0); 
AnalogIn left(PTC2);
AnalogIn middle(PTB3); 
AnalogIn right(PTB2);
AnalogIn rightmost(PTB1);

DigitalIn back(PTB10);
DigitalIn midbar(PTB11);
//DigitalIn front(PTE2);
DigitalIn front(PTA1);

//debugging led outputs
DigitalOut ledleftmost(PTE20);
DigitalOut ledright(PTE23);
DigitalOut ledmiddle(PTE22);
DigitalOut ledleft(PTE29);
DigitalOut ledrightmost(PTE21);



DigitalOut ledback(PTC4);
DigitalOut ledmidbar(PTB8);
DigitalOut ledfront(PTB9);

//ball firing
PwmOut motors(PTA12);
DigitalOut solenoid(PTA4);

//Ball dispensing
PwmOut dispenser(PTC8);


void turnleft(){
    ledleft=1;
    ENA=0.26;    
}

void rapidleft(){
    ledleftmost=1;
    ENA=0;     
}

void turnright(){
    ledright=1; 
    ENB=0.26; 
}

void rapidright(){
    ledrightmost=1;
    ENB=0;  
}

void fireball(){
    ENA=0;
    ENB=0;
    motors=0.095;
    wait_ms(550);
    solenoid=1;
    wait_ms(45);
    solenoid=0;
    wait(3);
    motors=0;   
}

void dispenseball(){
    ENA=0;
    ENB=0;
    wait(3);    
}

int counter=0;

void checkbarcode(){
    
    if(front==1){
        ENA=0.3;
        ENB=0.3;
        ledfront=1;
                
        counter=0;
        
        while(counter<600){
            if(midbar==1 and back==1){
                fireball();
                ENA=0.4;
                ENB=0.4;
                wait(5);
                break;
            }else if(front==1 and back==1){
                dispenseball();
                ENA=0.4;
                ENB=0.4;
                wait(5);  
                break; 
            }     
            counter=counter+1;
            wait(0.05);
        }
        
        ledfront=0;
            
            
    }  

}

void resetled(){
    ledmiddle=0;  
    ledleft=0;
    ledright=0;
    ledleftmost=0;  
    ledrightmost=0;
}

int main() {
    
    
    
    pull1=0;
    pull2=0;
    pull6=0;
    pull9=0;
    pull10=0;
    pull11=0;
    pull12=0;
    pull13=0;
    pull14=0;
    pull15=0;
    pull16=0;
    pull19=0;
    pull21=0;
    pull22=0;
    pull23=0;
    pull24=0;
    pull25=0;
    pull26=0;
    pull27=0;
    pull28=0;
    pull29=0;

   
    
    motors.period(3.0);
    motors.write(0);
    solenoid=0;
    
    constant1=1;
    constant2=1;
    constant3=1;
    constant4=1;
    constant5=1;
    
    indicator=1;
    wait(0.3);
    indicator=0;
    wait(0.3);
    indicator=1;
    wait(0.3);
    indicator=0;
    
    //define pwn freq for dispenser
    dispenser.period(1/2048);
    
            
    dispenser=0.5;
    
    ENA.period(0.001);
    ENB.period(0.001);
    
    IN1=0;
    IN2=1;
    IN3=0;
    IN4=1;   
    //set inital pwm values for motor driver outputs        
    ENA=0;
    ENB=0;
    
    //front.rise(&checkbarcode);

    while(1) {
        
        if(middle<0.4 & left<0.4 & right<0.4 & leftmost<0.4 & rightmost<0.4){
            //skip the loop, keep the same values 
              
        }else{
            
            resetled();
            
            checkbarcode();
            
            if(middle<0.4){
                ENA=0.45;
                ENB=0.45;   
                ledmiddle=1; 
            }else{
                ENA=0.4;
                ENB=0.4; 
                ledmiddle=0; 
            }
            
            checkbarcode();
            
            if((left>0.4 or leftmost>0.4)and(right>0.4 or rightmost>0.4)){
                rapidleft();
                wait(2);      
            }else if(leftmost>0.4){
                rapidleft();  
            }else if(rightmost>0.4){
                rapidright(); 
            }else if(right>0.4){
                turnright();   
            }else if(left>0.4){
                turnleft();  
            }else{
                //skip the loop, keep the same values  
            }     
            
            checkbarcode();
            
            if(front==1) {
                ledfront=1;
            }else{
                ledfront=0;
            }
            
            checkbarcode();
         
            if(midbar==1) {
                ledmidbar=1;
            }else{
                ledmidbar=0;
            }
            
            checkbarcode();
         
            if(back==1) {
                ledback=1;
            }else{
                ledback=0;
            }
            
            checkbarcode();
                        
        }      

           
        wait(0.01);
       
       
    }
}
