#include "mbed.h"
#include "MCP23008.h"
#include "MODSERIAL.h"


namespace {
    const uint8_t I2C_WRITE         = 0x00;
    const uint8_t I2C_READ          = 0x01;

    /* MCP23008 registers */
    const uint8_t IODIR             = 0x00;
    const uint8_t GPIO              = 0x09;
    const uint8_t PULLUP            = 0x06;
    
    //Channel addresses
    const uint8_t CHNL_0     = 0x01;
    const uint8_t CHNL_1     = 0x02;
    const uint8_t CHNL_2     = 0x04;
    const uint8_t CHNL_3     = 0x08;
};

MCP23008::MCP23008 (PinName sda, PinName scl, uint8_t address, int freq): i2c( sda, scl ){
    addrI2C = address;
    i2c.frequency(freq);
}

void MCP23008::setAddress(int address){
    addrI2C = address;
}

int MCP23008::writeOutput(int chn1, int chn2, int chn3, int chn4){
    char data[2];
    char data2[2];
    uint8_t val = 0x00;
    
    //Create mask for all bits that should be on
    if(chn1) val = val | CHNL_0;
    if(chn2) val = val | CHNL_1;
    if(chn3) val = val | CHNL_2;
    if(chn4) val = val | CHNL_3;
        
    data[0] = GPIO;  //register address
    data[1] = val;   //GPIO bit map
    data2[0] = PULLUP;
    data2[1] = 0x00;

    i2c.write((addrI2C<<1)|(I2C_WRITE), data, 2);
    return i2c.write((addrI2C<<1)|(I2C_WRITE), data2, 2);
    //wait(0.02);
}

void MCP23008::init(){
    char io_setup[2];
    
    io_setup[0] = IODIR;
    io_setup[1] = 0x00; //turn all pins to outputs
    
    i2c.write((addrI2C<<1)|(I2C_WRITE), io_setup, 2);
    //wait(0.1);
    
    //Set all outputs to off
    GPIO_Pin_Status = 0x00;
}